<?php
	/*
	Plugin Name: Tour Master
	Plugin URI: 
	Description: Tour management system plugin
	Version: 5.2.4
	Author: Goodlayers
	Author URI: http://www.goodlayers.com
	License: 
	*/

	// define necessary variable for the site.
	define('TOURMASTER_URL', plugins_url('', __FILE__));
	define('TOURMASTER_LOCAL', dirname(__FILE__));

	// init the ajax variable for wpml compatibility
	add_action('plugins_loaded', 'tourmaster_ajax_url', 1);
	if( !function_exists('tourmaster_ajax_url') ){
		function tourmaster_ajax_url(){
			global $sitepress;
			if( !empty($sitepress) ){
				define('TOURMASTER_AJAX_URL', admin_url('admin-ajax.php?lang=' . $sitepress->get_current_language()));
			}else{
				define('TOURMASTER_AJAX_URL', admin_url('admin-ajax.php'));
			}
		}
	}

	include_once(TOURMASTER_LOCAL . '/framework/framework.php');
	include_once(TOURMASTER_LOCAL . '/include/global-option.php');
	include_once(TOURMASTER_LOCAL . '/include/custom-filter.php');
	include_once(TOURMASTER_LOCAL . '/include/plugin-init.php');

	$enable_tour = tourmaster_get_option('general', 'enable-tour', 'enable');
	if( $enable_tour == 'enable' ){
		include_once(TOURMASTER_LOCAL . '/tour/functions-tour.php');
	}

	$enable_room = tourmaster_get_option('general', 'enable-room', 'enable');
	if( $enable_room == 'enable' ){
		include_once(TOURMASTER_LOCAL . '/room/functions-room.php');
	}

	// $enable_car = tourmaster_get_option('general', 'enable-car', 'enable');
	// if( $enable_room == 'enable' ){
	// 	include_once(TOURMASTER_LOCAL . '/car/functions-car.php');
	// }

	include_once(TOURMASTER_LOCAL . '/include/payment-util.php');
	include_once(TOURMASTER_LOCAL . '/include/booked-payment-util.php');
	include_once(TOURMASTER_LOCAL . '/include/deposit-util.php');
	include_once(TOURMASTER_LOCAL . '/include/user-util.php');
	include_once(TOURMASTER_LOCAL . '/include/table-util.php');
	include_once(TOURMASTER_LOCAL . '/include/mail-util.php');
	include_once(TOURMASTER_LOCAL . '/include/shortcodes-list.php');
	include_once(TOURMASTER_LOCAL . '/include/shortcodes.php');
	include_once(TOURMASTER_LOCAL . '/include/utility.php');

	include_once(TOURMASTER_LOCAL . '/include/template-settings.php');
	include_once(TOURMASTER_LOCAL . '/include/paypal.php');
	include_once(TOURMASTER_LOCAL . '/include/paypal-js-sdk.php');
	
	///////////// payment ///////////////
	include_once(TOURMASTER_LOCAL . '/include/stripe/stripe.php');
	// include_once(TOURMASTER_LOCAL . '/include/paymill/paymill.php');
	include_once(TOURMASTER_LOCAL . '/include/authorize/authorize.php');
	include_once(TOURMASTER_LOCAL . '/include/hipayprofessional.php');
	
	// add activation hook
	register_activation_hook(__FILE__, 'tourmaster_plugin_activation');
	register_deactivation_hook(__FILE__, 'tourmaster_plugin_deactivation');

	// load text domain for localization
	add_action('init', 'tourmaster_load_textdomain');
	if( !function_exists('tourmaster_load_textdomain') ){
		function tourmaster_load_textdomain() {
		  	load_plugin_textdomain('tourmaster', false, plugin_basename(dirname(__FILE__)) . '/languages'); 
		}
	}	
	
	// enqueue necessay style/script
	if( !is_admin() ){ 
		add_action('wp_enqueue_scripts', 'tourmaster_enqueue_script'); 
	}else{
		add_action('gdlr_core_front_script', 'tourmaster_enqueue_script');
	}
	if( !function_exists('tourmaster_enqueue_script') ){
		function tourmaster_enqueue_script(){
			tourmaster_enqueue_icon();

			wp_enqueue_script('jquery-ui-core');
			wp_enqueue_script('jquery-ui-datepicker');
			wp_enqueue_script('jquery-effects-core');

			wp_enqueue_style('tourmaster-style', TOURMASTER_URL . '/tourmaster.css', null, '4.1.4');
			if( is_rtl() ){
				wp_enqueue_style('tourmaster-style-rtl', TOURMASTER_URL . '/tourmaster-rtl.css');
			}

			wp_enqueue_style('tourmaster-global-custom-style', tourmaster_global_get_style_custom());
			
			wp_enqueue_script('tourmaster-script', TOURMASTER_URL . '/tourmaster.js', array('jquery'), false, true);

			// for localization of the datepicker
			// ref : https://gist.github.com/clubduece/4053820
			global $wp_locale;
			$aryArgs = array(
				'closeText'         => esc_html__('Done', 'tourmaster'),
				'currentText'       => esc_html__('Today', 'tourmaster'),
				'monthNames'        => tourmaster_strip_array_indices($wp_locale->month),
				'monthNamesShort'   => tourmaster_strip_array_indices($wp_locale->month_abbrev),
				'dayNames'          => tourmaster_strip_array_indices($wp_locale->weekday),
				'dayNamesShort'     => tourmaster_strip_array_indices($wp_locale->weekday_abbrev),
				'dayNamesMin'       => tourmaster_strip_array_indices($wp_locale->weekday_initial),
				'firstDay'          => get_option('start_of_week')
			);
			wp_localize_script( 'tourmaster-script', 'TMi18n', $aryArgs );
		}
	}
	if( !function_exists('tourmaster_strip_array_indices') ){
		function tourmaster_strip_array_indices( $arrayToStrip ){
			$newArray = array();
			foreach( $arrayToStrip as $objArrayItem){
				$newArray[] =  $objArrayItem;
			}

			return $newArray;
		}
	}	

	// add tourmaster to body class
	add_filter('body_class', 'tourmaster_body_class');
	if( !function_exists('tourmaster_body_class') ){
		function tourmaster_body_class( $classes ){
			$classes[] = 'tourmaster-body';
			
			return $classes;
		}
	}

	// import tourmaster admin panel data
	add_action('gdlr_core_import_additional_options', 'tourmaster_gdlr_core_import_additional_options', 10, 1);
	if( !function_exists('tourmaster_gdlr_core_import_additional_options') ){
		function tourmaster_gdlr_core_import_additional_options( $slug ){
			if( $slug == 'traveltour-full' ){
				$data = '{"tourmaster_general":{"container-width":"1180px","container-padding":"20px","item-padding":"20px","datepicker-date-format":"d M yy","money-format":"$NUMBER","tax-rate":"9","login-page":"4852","register-page":"4854","user-page":"4833","user-navigation-bottom-text":"<h5>Need Help?<\/5>\n[gdlr_core_space height=\"1px\"]\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"18px\" color=\"#444\" margin-right=\"10px\" ] <span style=\"font-size: 15px; font-weight: 400;\"> 1.828.456.345\n<a href=\"#\">Help@traveltourwp.com<\/a>","payment-page":"","payment-complete-bottom-text":"","search-page":"4858","search-page-num-fetch":"6","search-page-tour-style":"medium-with-frame","search-page-with-frame":"enable","search-page-column-size":"20","search-page-thumbnail-size":"Tour Category","search-page-tour-info":["duration-text","availability"],"search-page-excerpt":"specify-number","search-page-excerpt-number":"14","search-page-tour-rating":"enable","invoice-logo":"4890","invoice-logo-width":"250px","invoice-company-name":"GoodLayers Travel Tour","invoice-company-info":"11 Main Street, Kingston, London 22EPH","text":"","textarea":"","combobox":"1","multi-combobox":"","radioimage":"1","checkbox":"disable","tour-header-top-padding":"500px","tour-header-bottom-padding":"45px","single-tour-default-sidebar":"single-tour","payment-page-sidebar":"payment","archive-page":"","search-sidebar":"right","search-sidebar-left":"none","search-sidebar-right":"single-tour","system-email-address":"","admin-email-address":"","mail-header-logo":"","mail-footer-left":"<span style=\"font-weight: bold\" >Need help?<\/span>\n<a href=\"mailto:help@traveltourwptheme.com\">help@traveltourwptheme.com<\/a>\n1.828.344.234","mail-footer-right":"<span><\/span>\nLogin to <a href=\"http:\/\/demo.goodlayers.com\/traveltour\/login\">your account<\/a>\nCopyright \u00a9 2017, GoodLayers","enable-admin-booking-made-mail":"enable","admin-booking-made-mail-title":"A new booking has been made","admin-booking-made-mail":"<strong>Dear Admin,<\/strong>\nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-admin-payment-submitted-mail":"enable","admin-payment-submitted-mail-title":"A new payment receipt has been submitted","admin-payment-submitted-mail":"<strong>Dear Admin,<\/strong>\nA new payment receipt has been submitted\n\n{tour-name}\n{order-number}\n{travel-date}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-admin-online-payment-made-mail":"enable","admin-online-payment-made-mail-title":"A new booking has been made and successfully paid","admin-online-payment-made-mail":"<strong>Dear Admin,<\/strong>\nA new booking has been made and sucessfully paid.\n\n{payment-method}\n{payment-date}\n{transaction-id}\n{spaces}\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-registration-complete-mail":"enable","registration-complete-mail-title":"Congratulations! Your account has been created","registration-complete-mail":"{header}Congratulations {customer-name}!{\/header}\n\nYour account has been successfully created. Now you can explore new tours and mange booking via the dashboard. You can also review tours and make a wishlist from the dashboard as well.\n\n<a href=\"{profile-page-link}\" >Click here to login to travel tour<\/a>","enable-booking-made-mail":"enable","booking-made-mail-title":"You have made a new booking","booking-made-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-payment-made-mail":"enable","payment-made-mail-title":"Your payment has been successfully processed","payment-made-mail":"<strong>Dear {customer-name}<\/strong>,\nCongratulations! Your payment has been sucessfully processed.\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\n{payment-method}\n{payment-date}\n{transaction-id}\n{spaces}\n\nYou can view <a href=\"{invoice-link}\">the receipt here<\/a>","enable-booking-cancelled-mail":"enable","booking-cancelled-mail-title":"Your booking has been cancelled","booking-cancelled-mail":"<strong>Dear {customer-name}<\/strong>,\nWe are here to inform that your booking has been cancelled.\n\n{tour-name}\n{order-number}\n{travel-date}","enable-booking-reject-mail":"enable","booking-reject-mail-title":"Your booking has been rejected","booking-reject-mail":"<strong>Dear {customer-name}<\/strong>,\nWe are sorry to inform that your booking has been rejected. Your booking was rejected because of your payment was not successfully processed or your booking might be in the pending status for too long.\n\n{tour-name}\n{order-number}\n{travel-date}","enable-booking-via-email":"enable","enable-admin-guest-booking-made-mail":"enable","admin-guest-booking-made-mail-title":"A new booking has been made (Guest booked via email)","admin-guest-booking-made-mail":"<strong>Dear Admin,<\/strong> \nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>\n{spaces}\n\nCustomer\u2019s email : {customer-email}\nPlease contact to your customer back for further details.","enable-guest-booking-made-mail":"enable","guest-booking-made-mail-title":"You have made a new booking via email","guest-booking-made-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n{divider}\nOur team will contact you back via the email you provided,\n{customer-email}","price-breakdown-decimal-digit":"2","register-term-of-service-page":"","register-privacy-statement-page":"","user-default-country":"","cancel-booking-day":"","tour-staff-capability":["edit_tour","read_tour","delete_tour","edit_tours","edit_others_tours","publish_tours","read_private_tours","manage_tour_category","manage_tour_tag","manage_tour_filter","edit_coupon","read_coupon","delete_coupon","edit_coupons","edit_others_coupons","publish_coupons","read_private_coupons","manage_tour_order","edit_service","read_service","delete_service","edit_services","edit_others_services","publish_services","read_private_services"],"tour-author-capability":["edit_tour","read_tour","delete_tour","edit_tours","edit_others_tours","publish_tours","read_private_tours","manage_tour_category","manage_tour_tag","manage_tour_filter","edit_coupon","read_coupon","delete_coupon","edit_coupons","edit_others_coupons","publish_coupons","read_private_coupons"],"tour-search-item-style":"medium-with-frame","tour-search-item-thumbnail":"Tour Category","tour-search-item-info":["duration-text","availability"],"tour-search-item-excerpt":"specify-number","tour-search-item-excerpt-number":"14","tour-search-item-rating":"enable","tour-search-order-filterer-grid-style":"grid-with-frame","tour-search-order-filterer-grid-style-thumbnail":"Blog Column Thumbnail","tour-search-order-filterer-grid-style-column":"30","enable-tour-search-filter":"enable","tour-search-fields":["keywords","tour_category","tour_tag","duration","date","min-price","max-price"],"tour-search-rating-field":"enable","tour-search-filters":["tour-age","tour-activity","tour-destination"],"search-not-found-fields":"","search-not-found-style":"column","show-remaining-available-number":"enable","max-dropdown-people-amount":"5","enable-single-sidebar-widget-on-mobile":"enable","enable-single-related-tour":"enable","single-related-tour-style":"grid","single-related-tour-column-size":"30","single-related-tour-num-fetch":"2","single-related-tour-thumbnail-size":"large","single-related-tour-price-position":"right-title","single-related-tour-info":"","single-related-tour-excerpt":"none","single-related-tour-excerpt-number":"20","single-related-tour-rating":"enable","system-email-name":"WORDPRESS","admin-enquiry-mail-title":"You received a new enquiry","admin-enquiry-mail-content":"Dear Admin,\n\nYou received a new enquiry from {tour-name}\n\nFrom: {full-name}\n\nEmail: {email-address} \n\nMessage: {your-enquiry}\n\n","enquiry-mail-title":"You have submitted an enquiry","enquiry-mail-content":"Dear {full-name},\n\nYou have sumiited an enquiry from {tour-name}\n\nMessage: {your-enquiry}\n\nOur team will contact you back via the email you provided, {email-address} \n\nThank you!","tour-search-item-num-fetch":"9","enable-tour-schema":"enable","tour-schema-price-currency":"","tour-header-overlay-opacity":"10","max-dropdown-room-amount":"10"},"tourmaster_payment":{"stripe-secret-key":"","stripe-publishable-key":"","stripe-currency-code":"usd","paypal-live-mode":"disable","paypal-business-email":"","paypal-currency-code":"USD","payment-method":["booking","paypal","credit-card"],"accepted-credit-card-type":["visa","master-card","american-express","jcb"],"term-of-service-page":"","privacy-statement-page":"","credit-card-payment-gateway":"stripe","paymill-private-key":"","paymill-public-key":"","paymill-currency-code":"usd","authorize-live-mode":"disable","authorize-api-id":"","authorize-transaction-key":"","enable-deposit-payment":"enable","deposit-payment-amount":"30","display-deposit-payment-day":"","paypal-service-fee":"3"},"tourmaster_color":{"tourmaster-theme-color":"#485da1","tourmaster-rating-color":"#ffa127","user-template-background":"#f3f3f3","user-template-navigation-background":"#ffffff","user-template-navigation-title":"#3f3f3f","user-template-navigation-text":"#7d7d7d","user-template-navigation-border":"#e5e5e5","user-template-breadcrumbs-text":"#a5a5a5","user-template-content-block-background":"#ffffff","user-template-content-block-title-link":"#9e9e9e","user-template-content-block-border":"#e8e8e8","user-template-content-block-text":"#545454","tourmaster-input-box-text":"#545454","tourmaster-input-box-background":"#ffffff","tourmaster-input-box-border":"#e6e6e6","tourmaster-upload-box-background":"#f3f3f3","tourmaster-upload-box-text":"#a6a6a6","tourmaster-theme-color-link":"#4674e7","tourmaster-theme-color-light":"#4692e7","tourmaster-single-price-head-background":"#4675e7","tourmaster-single-price-head-featured-background":"#2c487a","tourmaster-single-price-head-discount-text":"#b9daff","tourmaster-remove-color":"#ba4a4a","user-login-submenu-background":"#ffffff","user-login-submenu-border":"#e6e6e6","user-login-submenu-text":"#878787","user-template-my-booking-price-text":"#424242","user-template-my-booking-filter-text":"#a5a5a5","tourmaster-booking-status-text-color":"#acacac","tourmaster-booking-status-pending-color":"#24a04a","tourmaster-booking-status-online-paid":"#cd9b45","tourmaster-booking-receipt-button-background":"#48a198","tourmaster-invoice-title-color":"#121212","tourmaster-invoice-price-head-background":"#f3f3f3","tourmaster-invoice-price-head-text":"#454545","tourmaster-invoice-price-text":"#7b7b7b","tourmaster-invoice-price-amount":"#1e1e1e","tourmaster-input-form-label":"#5c5c5c","tourmaster-datepicker-background":"#f5f5f5","tourmaster-datepicker-border":"#ebebeb","tourmaster-datepicker-head":"#808080","tourmaster-datepicker-enable-background":"#ffffff","tourmaster-datepicker-enable-text":"#5b5b5b","tourmaster-datepicker-disable-text":"#c0c0c0","tourmaster-booking-bar-background":"#ffffff","tourmaster-booking-bar-text":"#333333","tourmaster-booking-bar-wishlist-background":"#fbfbfb","tourmaster-booking-bar-wishlist-border":"#ebebeb","tourmaster-booking-bar-summary-title":"#000000","tourmaster-booking-bar-summary-text":"#414141","tourmaster-price-breakdown-color":"#515151","tourmaster-price-breakdown-total-color":"#242424","single-tour-info-background":"#f5f5f5","single-tour-info-text":"#414141","tourmaster-review-title-color":"#272727","tourmaster-review-date-color":"#a3a3a3","tourmaster-payment-complete-background":"#f5f5f5","tourmaster-payment-complete-title":"#262626","tourmaster-payment-complete-border":"#e3e3e3","tourmaster-pagination-background":"#696969","tourmaster-pagination-text":"#f3f3f3","tourmaster-payment-step-icon-background":"#161616","tour-item-frame-background":"#ffffff","tour-price":"#1b1b1b","tour-discount-price":"#aaaaaa","tourmaster-lightbox-background":"#ffffff","tourmaster-lightbox-title":"#0e0e0e","tourmaster-lightbox-form-label":"#5c5c5c","tourmaster-content-navigation-background":"#ebebeb","tourmaster-content-navigation-text":"#9a9a9a","tourmaster-content-navigation-active-text":"#1b1b1b","tourmaster-search-frame-background":"#ffffff","tourmaster-single-price-head-background-right":"#4692e7","tour-item-title-color":"#333333","tour-grid-bottom-price-background":"#e7e7e7","tour-grid-bottom-price-head":"#5c5c5c","tour-grid-bottom-discount-price":"#989898","tourmaster-input-box-background-validate-error":"#fff9f9","search-page-background":"#f3f3f3","tourmaster-search-input-background":"#f3f3f3","tourmaster-search-input-border":"#f3f3f3","tourmaster-search-input-text":"#7f7f7f","tourmaster-search-input-icon":"#383838","tourmaster-tour-review-title":"#313131","tourmaster-tour-review-user-name":"#5f5f5f","tourmaster-search-input-title":"#ffffff","tourmaster-search-input-label":"#383838","tourmaster-booking-status-deposit-paid":"#5b9dd9","tourmaster-price-breakdown-total-color-deposit":"#a1a1a1","payment-service-form-background":"#f5f5f5","payment-service-form-title":"#1a1a1a","payment-service-form-title-border":"#e3e3e3","payment-service-form-label":"#6a6a6a","search-not-found-background":"#f6f6f6","search-not-found-title":"#cccccc","search-not-found-caption":"#a8a8a8","booking-bar-tab-title-background":"#f5f5f5","booking-bar-tab-title-text":"#929292","booking-bar-tab-active-title-text":"#242424","enquery-success-message-background":"#f1f8ff","enquery-success-message-border":"#e1ebfe","enquery-success-message-text":"#758ea8","enquery-failed-message-background":"#fff1f1","enquery-failed-message-border":"#fee1e1","enquery-failed-message-text":"#ffffff","urgency-message-background":"#343434","urgency-message-text":"#a87575","tour-item-order-filterer-background":"#ffffff","tour-item-order-filterer-combobox-background":"#ffffff","tour-item-order-filterer-icon":"#adadad","tourmaster-search-filter-text":"#878787"},"tourmaster_plugin":{"font-awesome":"enable","elegant-icon":"enable"}}';
			}else if( $slug == 'citytour' ){
				$data = '{"tourmaster_general":{"container-width":"1240px","container-padding":"17px","item-padding":"17px","datepicker-date-format":"d M yy","money-format":"$NUMBER","tax-rate":"9","login-page":"4852","register-page":"4854","user-page":"4833","user-navigation-bottom-text":"<h5>Need Help?<\/5>\n[gdlr_core_space height=\"1px\"]\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"18px\" color=\"#444\" margin-right=\"10px\" ] <span style=\"font-size: 15px; font-weight: 400;\"> 1.828.456.345\n<a href=\"#\">Help@traveltourwp.com<\/a>","payment-page":"","payment-complete-bottom-text":"","search-page":"4858","search-page-num-fetch":"6","search-page-tour-style":"medium-with-frame","search-page-with-frame":"enable","search-page-column-size":"20","search-page-thumbnail-size":"Tour Category","search-page-tour-info":["duration-text","availability"],"search-page-excerpt":"specify-number","search-page-excerpt-number":"14","search-page-tour-rating":"enable","invoice-logo":"4890","invoice-logo-width":"250px","invoice-company-name":"GoodLayers Travel Tour","invoice-company-info":"11 Main Street, Kingston, London 22EPH","text":"","textarea":"","combobox":"1","multi-combobox":"","radioimage":"1","checkbox":"disable","tour-header-top-padding":"500px","tour-header-bottom-padding":"45px","single-tour-default-sidebar":"single-tour","payment-page-sidebar":"payment","archive-page":"","search-sidebar":"right","search-sidebar-left":"none","search-sidebar-right":"tour-list","system-email-address":"","admin-email-address":"","mail-header-logo":"4925","mail-footer-left":"<span style=\"font-weight: bold\" >Need help?<\/span>\n<a href=\"mailto:help@traveltourwptheme.com\">help@traveltourwptheme.com<\/a>\n1.828.344.234","mail-footer-right":"<span><\/span>\nLogin to <a href=\"http:\/\/demo.goodlayers.com\/traveltour\/login\">your account<\/a>\nCopyright \u00a9 2017, GoodLayers","enable-admin-booking-made-mail":"enable","admin-booking-made-mail-title":"A new booking has been made","admin-booking-made-mail":"<strong>Dear Admin,<\/strong>\nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-admin-payment-submitted-mail":"enable","admin-payment-submitted-mail-title":"A new payment receipt has been submitted","admin-payment-submitted-mail":"<strong>Dear Admin,<\/strong>\nA new payment receipt has been submitted\n\n{tour-name}\n{order-number}\n{travel-date}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-admin-online-payment-made-mail":"enable","admin-online-payment-made-mail-title":"A new booking has been made and successfully paid","admin-online-payment-made-mail":"<strong>Dear Admin,<\/strong>\nA new booking has been made and sucessfully paid.\n\n{payment-method}\n{payment-date}\n{transaction-id}\n{spaces}\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-registration-complete-mail":"enable","registration-complete-mail-title":"Congratulations! Your account has been created","registration-complete-mail":"{header}Congratulations {customer-name}!{\/header}\n\nYour account has been successfully created. Now you can explore new tours and mange booking via the dashboard. You can also review tours and make a wishlist from the dashboard as well.\n\n<a href=\"{profile-page-link}\" >Click here to login to travel tour<\/a>","enable-booking-made-mail":"enable","booking-made-mail-title":"You have made a new booking","booking-made-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-payment-made-mail":"enable","payment-made-mail-title":"Your payment has been successfully processed","payment-made-mail":"<strong>Dear {customer-name}<\/strong>,\nCongratulations! Your payment has been sucessfully processed.\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\n{payment-method}\n{payment-date}\n{transaction-id}\n{spaces}\n\nYou can view <a href=\"{invoice-link}\">the receipt here<\/a>","enable-booking-cancelled-mail":"enable","booking-cancelled-mail-title":"Your booking has been cancelled","booking-cancelled-mail":"<strong>Dear {customer-name}<\/strong>,\nWe are here to inform that your booking has been cancelled.\n\n{tour-name}\n{order-number}\n{travel-date}","enable-booking-reject-mail":"enable","booking-reject-mail-title":"Your booking has been rejected","booking-reject-mail":"<strong>Dear {customer-name}<\/strong>,\nWe are sorry to inform that your booking has been rejected. Your booking was rejected because of your payment was not successfully processed or your booking might be in the pending status for too long.\n\n{tour-name}\n{order-number}\n{travel-date}","enable-booking-via-email":"enable","enable-admin-guest-booking-made-mail":"enable","admin-guest-booking-made-mail-title":"A new booking has been made (Guest booked via email)","admin-guest-booking-made-mail":"<strong>Dear Admin,<\/strong> \nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>\n{spaces}\n\nCustomer\u2019s email : {customer-email}\nPlease contact to your customer back for further details.","enable-guest-booking-made-mail":"enable","guest-booking-made-mail-title":"You have made a new booking via email","guest-booking-made-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n{divider}\nOur team will contact you back via the email you provided,\n{customer-email}","price-breakdown-decimal-digit":"2","register-term-of-service-page":"","register-privacy-statement-page":"","user-default-country":"","cancel-booking-day":"","tour-staff-capability":["edit_tour","read_tour","delete_tour","edit_tours","edit_others_tours","publish_tours","read_private_tours","manage_tour_category","manage_tour_tag","manage_tour_filter","edit_coupon","read_coupon","delete_coupon","edit_coupons","edit_others_coupons","publish_coupons","read_private_coupons","manage_tour_order","edit_service","read_service","delete_service","edit_services","edit_others_services","publish_services","read_private_services"],"tour-author-capability":["edit_tour","read_tour","delete_tour","edit_tours","edit_others_tours","publish_tours","read_private_tours","manage_tour_category","manage_tour_tag","manage_tour_filter","edit_coupon","read_coupon","delete_coupon","edit_coupons","edit_others_coupons","publish_coupons","read_private_coupons"],"tour-search-item-style":"medium-with-frame","tour-search-item-thumbnail":"Tour Category","tour-search-item-info":["duration-text","availability"],"tour-search-item-excerpt":"specify-number","tour-search-item-excerpt-number":"14","tour-search-item-rating":"enable","tour-search-order-filterer-grid-style":"grid-with-frame","tour-search-order-filterer-grid-style-thumbnail":"Blog Column Thumbnail","tour-search-order-filterer-grid-style-column":"30","enable-tour-search-filter":"enable","tour-search-fields":["keywords","tour_category","tour_tag","duration","date","min-price","max-price"],"tour-search-rating-field":"enable","tour-search-filters":["tour-age","tour-activity","tour-destination"],"search-not-found-fields":"","search-not-found-style":"column","show-remaining-available-number":"enable","max-dropdown-people-amount":"5","enable-single-sidebar-widget-on-mobile":"enable","enable-single-related-tour":"enable","single-related-tour-style":"grid","single-related-tour-column-size":"30","single-related-tour-num-fetch":"2","single-related-tour-thumbnail-size":"Portfolio Thumbnail","single-related-tour-price-position":"right-title","single-related-tour-info":"","single-related-tour-excerpt":"none","single-related-tour-excerpt-number":"20","single-related-tour-rating":"enable","system-email-name":"WORDPRESS","admin-enquiry-mail-title":"You received a new enquiry","admin-enquiry-mail-content":"Dear Admin,\n\nYou received a new enquiry from {tour-name}\n\nFrom: {full-name}\n\nEmail: {email-address} \n\nMessage: {your-enquiry}\n\n","enquiry-mail-title":"You have submitted an enquiry","enquiry-mail-content":"Dear {full-name},\n\nYou have sumiited an enquiry from {tour-name}\n\nMessage: {your-enquiry}\n\nOur team will contact you back via the email you provided, {email-address} \n\nThank you!","tour-search-item-num-fetch":"9","enable-tour-schema":"enable","tour-schema-price-currency":"USD","tour-header-overlay-opacity":"30","max-dropdown-room-amount":"10"},"tourmaster_payment":{"stripe-secret-key":"","stripe-publishable-key":"","stripe-currency-code":"usd","paypal-live-mode":"disable","paypal-business-email":"","paypal-currency-code":"USD","payment-method":["booking","paypal","credit-card"],"accepted-credit-card-type":["visa","master-card","american-express","jcb"],"term-of-service-page":"","privacy-statement-page":"","credit-card-payment-gateway":"stripe","paymill-private-key":"","paymill-public-key":"","paymill-currency-code":"usd","authorize-live-mode":"disable","authorize-api-id":"","authorize-transaction-key":"","enable-deposit-payment":"enable","deposit-payment-amount":"30","display-deposit-payment-day":"","paypal-service-fee":"3"},"tourmaster_color":{"tourmaster-theme-color":"#ea5318","tourmaster-rating-color":"#ffa127","user-template-background":"#f3f3f3","user-template-navigation-background":"#ffffff","user-template-navigation-title":"#3f3f3f","user-template-navigation-text":"#7d7d7d","user-template-navigation-border":"#e5e5e5","user-template-breadcrumbs-text":"#a5a5a5","user-template-content-block-background":"#ffffff","user-template-content-block-title-link":"#9e9e9e","user-template-content-block-border":"#e8e8e8","user-template-content-block-text":"#545454","tourmaster-input-box-text":"#545454","tourmaster-input-box-background":"#ffffff","tourmaster-input-box-border":"#e6e6e6","tourmaster-upload-box-background":"#f3f3f3","tourmaster-upload-box-text":"#a6a6a6","tourmaster-theme-color-link":"#ea5318","tourmaster-theme-color-light":"#ea6c18","tourmaster-single-price-head-background":"#ea5318","tourmaster-single-price-head-featured-background":"#c74410","tourmaster-single-price-head-discount-text":"#eaa87c","tourmaster-remove-color":"#ba4a4a","user-login-submenu-background":"#ffffff","user-login-submenu-border":"#e6e6e6","user-login-submenu-text":"#878787","user-template-my-booking-price-text":"#424242","user-template-my-booking-filter-text":"#a5a5a5","tourmaster-booking-status-text-color":"#acacac","tourmaster-booking-status-pending-color":"#24a04a","tourmaster-booking-status-online-paid":"#cd9b45","tourmaster-booking-receipt-button-background":"#48a198","tourmaster-invoice-title-color":"#121212","tourmaster-invoice-price-head-background":"#f3f3f3","tourmaster-invoice-price-head-text":"#454545","tourmaster-invoice-price-text":"#7b7b7b","tourmaster-invoice-price-amount":"#1e1e1e","tourmaster-input-form-label":"#5c5c5c","tourmaster-datepicker-background":"#f5f5f5","tourmaster-datepicker-border":"#ebebeb","tourmaster-datepicker-head":"#808080","tourmaster-datepicker-enable-background":"#ffffff","tourmaster-datepicker-enable-text":"#5b5b5b","tourmaster-datepicker-disable-text":"#c0c0c0","tourmaster-booking-bar-background":"#ffffff","tourmaster-booking-bar-text":"#333333","tourmaster-booking-bar-wishlist-background":"#fbfbfb","tourmaster-booking-bar-wishlist-border":"#ebebeb","tourmaster-booking-bar-summary-title":"#000000","tourmaster-booking-bar-summary-text":"#414141","tourmaster-price-breakdown-color":"#515151","tourmaster-price-breakdown-total-color":"#242424","single-tour-info-background":"#f5f5f5","single-tour-info-text":"#414141","tourmaster-review-title-color":"#272727","tourmaster-review-date-color":"#a3a3a3","tourmaster-payment-complete-background":"#f5f5f5","tourmaster-payment-complete-title":"#262626","tourmaster-payment-complete-border":"#e3e3e3","tourmaster-pagination-background":"#696969","tourmaster-pagination-text":"#f3f3f3","tourmaster-payment-step-icon-background":"#161616","tour-item-frame-background":"#ffffff","tour-price":"#1b1b1b","tour-discount-price":"#aaaaaa","tourmaster-lightbox-background":"#ffffff","tourmaster-lightbox-title":"#0e0e0e","tourmaster-lightbox-form-label":"#5c5c5c","tourmaster-content-navigation-background":"#ebebeb","tourmaster-content-navigation-text":"#9a9a9a","tourmaster-content-navigation-active-text":"#1b1b1b","tourmaster-search-frame-background":"#ffffff","tourmaster-single-price-head-background-right":"#ea6c18","tour-item-title-color":"#333333","tour-grid-bottom-price-background":"#e7e7e7","tour-grid-bottom-price-head":"#5c5c5c","tour-grid-bottom-discount-price":"#989898","tourmaster-input-box-background-validate-error":"#fff9f9","search-page-background":"#f3f3f3","tourmaster-search-input-background":"#f3f3f3","tourmaster-search-input-border":"#f3f3f3","tourmaster-search-input-text":"#7f7f7f","tourmaster-search-input-icon":"#383838","tourmaster-tour-review-title":"#313131","tourmaster-tour-review-user-name":"#5f5f5f","tourmaster-search-input-title":"#ffffff","tourmaster-search-input-label":"#383838","tourmaster-booking-status-deposit-paid":"#5b9dd9","tourmaster-price-breakdown-total-color-deposit":"#a1a1a1","payment-service-form-background":"#f5f5f5","payment-service-form-title":"#1a1a1a","payment-service-form-title-border":"#e3e3e3","payment-service-form-label":"#6a6a6a","search-not-found-background":"#f6f6f6","search-not-found-title":"#cccccc","search-not-found-caption":"#a8a8a8","booking-bar-tab-title-background":"#f5f5f5","booking-bar-tab-title-text":"#929292","booking-bar-tab-active-title-text":"#242424","enquery-success-message-background":"#f1f8ff","enquery-success-message-border":"#e1ebfe","enquery-success-message-text":"#758ea8","enquery-failed-message-background":"#fff1f1","enquery-failed-message-border":"#fee1e1","enquery-failed-message-text":"#ffffff","urgency-message-background":"#343434","urgency-message-text":"#a87575","tour-item-order-filterer-background":"#ffffff","tour-item-order-filterer-combobox-background":"#ffffff","tour-item-order-filterer-icon":"#adadad","tourmaster-search-filter-text":"#878787"},"tourmaster_plugin":{"font-awesome":"enable","elegant-icon":"enable"}}';
			}else if( $slug == 'yachttour'){
				$data = '{"tourmaster_general":{"container-width":"1320px","container-padding":"20px","item-padding":"20px","datepicker-date-format":"d M yy","money-format":"$NUMBER","tax-rate":"9","login-page":"4852","register-page":"4854","user-page":"4833","user-navigation-bottom-text":"<h5>Need Help?<\/5>\n[gdlr_core_space height=\"1px\"]\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"18px\" color=\"#444\" margin-right=\"10px\" ] <span style=\"font-size: 15px; font-weight: 400;\"> 1.828.456.345\n<a href=\"#\">Help@traveltourwp.com<\/a>","payment-page":"","payment-complete-bottom-text":"","search-page":"4858","search-page-num-fetch":"6","search-page-tour-style":"medium-with-frame","search-page-with-frame":"enable","search-page-column-size":"20","search-page-thumbnail-size":"Tour Category","search-page-tour-info":["duration-text","availability"],"search-page-excerpt":"specify-number","search-page-excerpt-number":"14","search-page-tour-rating":"enable","invoice-logo":"4890","invoice-logo-width":"250px","invoice-company-name":"GoodLayers Travel Tour","invoice-company-info":"11 Main Street, Kingston, London 22EPH","text":"","textarea":"","combobox":"1","multi-combobox":"","radioimage":"1","checkbox":"disable","tour-header-top-padding":"750px","tour-header-bottom-padding":"45px","single-tour-default-sidebar":"single-tour","payment-page-sidebar":"payment","archive-page":"","search-sidebar":"right","search-sidebar-left":"none","search-sidebar-right":"single-tour","system-email-address":"","admin-email-address":"","mail-header-logo":"5384","mail-footer-left":"<span style=\"font-weight: bold\" >Need help?<\/span>\n<a href=\"mailto:help@traveltourwptheme.com\">help@traveltourwptheme.com<\/a>\n1.828.344.234","mail-footer-right":"<span><\/span>\nLogin to <a href=\"http:\/\/demo.goodlayers.com\/traveltour\/login\">your account<\/a>\nCopyright \u00a9 2017, GoodLayers","enable-admin-booking-made-mail":"enable","admin-booking-made-mail-title":"A new booking has been made","admin-booking-made-mail":"<strong>Dear Admin,<\/strong>\nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n{traveller-amount}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-admin-payment-submitted-mail":"enable","admin-payment-submitted-mail-title":"A new payment receipt has been submitted","admin-payment-submitted-mail":"<strong>Dear Admin,<\/strong>\nA new payment receipt has been submitted\n\n{tour-name}\n{order-number}\n{travel-date}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-admin-online-payment-made-mail":"enable","admin-online-payment-made-mail-title":"A new booking has been made and successfully paid","admin-online-payment-made-mail":"<strong>Dear Admin,<\/strong>\nA new booking has been made and sucessfully paid.\n\n{payment-method}\n{payment-date}\n{transaction-id}\n{spaces}\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-registration-complete-mail":"enable","registration-complete-mail-title":"Congratulations! Your account has been created","registration-complete-mail":"{header}Congratulations {customer-name}!{\/header}\n\nYour account has been successfully created. Now you can explore new tours and mange booking via the dashboard. You can also review tours and make a wishlist from the dashboard as well.\n\n<a href=\"{profile-page-link}\" >Click here to login to travel tour<\/a>","enable-booking-made-mail":"enable","booking-made-mail-title":"You have made a new booking","booking-made-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-payment-made-mail":"enable","payment-made-mail-title":"Your payment has been successfully processed","payment-made-mail":"<strong>Dear {customer-name}<\/strong>,\nCongratulations! Your payment has been sucessfully processed.\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\n{payment-method}\n{payment-date}\n{transaction-id}\n{spaces}\n\nYou can view <a href=\"{invoice-link}\">the receipt here<\/a>","enable-booking-cancelled-mail":"enable","booking-cancelled-mail-title":"Your booking has been cancelled","booking-cancelled-mail":"<strong>Dear {customer-name}<\/strong>,\nWe are here to inform that your booking has been cancelled.\n\n{tour-name}\n{order-number}\n{travel-date}","enable-booking-reject-mail":"enable","booking-reject-mail-title":"Your booking has been rejected","booking-reject-mail":"<strong>Dear {customer-name}<\/strong>,\nWe are sorry to inform that your booking has been rejected. Your booking was rejected because of your payment was not successfully processed or your booking might be in the pending status for too long.\n\n{tour-name}\n{order-number}\n{travel-date}","enable-booking-via-email":"enable","enable-admin-guest-booking-made-mail":"enable","admin-guest-booking-made-mail-title":"A new booking has been made (Guest booked via email)","admin-guest-booking-made-mail":"<strong>Dear Admin,<\/strong> \nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>\n{spaces}\n\nCustomer\u2019s email : {customer-email}\nPlease contact to your customer back for further details.","enable-guest-booking-made-mail":"enable","guest-booking-made-mail-title":"You have made a new booking via email","guest-booking-made-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n{divider}\nOur team will contact you back via the email you provided,\n{customer-email}","price-breakdown-decimal-digit":"2","register-term-of-service-page":"5389","register-privacy-statement-page":"5389","user-default-country":"","cancel-booking-day":"","tour-staff-capability":["edit_tour","read_tour","delete_tour","edit_tours","edit_others_tours","publish_tours","read_private_tours","manage_tour_category","manage_tour_tag","manage_tour_filter","edit_coupon","read_coupon","delete_coupon","edit_coupons","edit_others_coupons","publish_coupons","read_private_coupons","manage_tour_order","edit_service","read_service","delete_service","edit_services","edit_others_services","publish_services","read_private_services"],"tour-author-capability":["edit_tour","read_tour","delete_tour","edit_tours","edit_others_tours","publish_tours","read_private_tours","manage_tour_category","manage_tour_tag","manage_tour_filter","edit_coupon","read_coupon","delete_coupon","edit_coupons","edit_others_coupons","publish_coupons","read_private_coupons"],"tour-search-item-style":"medium-with-frame","tour-search-item-thumbnail":"Tour Category","tour-search-item-info":["duration-text","availability"],"tour-search-item-excerpt":"specify-number","tour-search-item-excerpt-number":"14","tour-search-item-rating":"enable","tour-search-order-filterer-grid-style":"grid-with-frame","tour-search-order-filterer-grid-style-thumbnail":"Blog Column Thumbnail","tour-search-order-filterer-grid-style-column":"30","enable-tour-search-filter":"enable","tour-search-fields":["keywords","duration","date","min-price","max-price"],"tour-search-rating-field":"enable","tour-search-filters":["tour-age","tour-activity","tour-destination"],"search-not-found-fields":"","search-not-found-style":"column","show-remaining-available-number":"enable","max-dropdown-people-amount":"6","enable-single-sidebar-widget-on-mobile":"enable","enable-single-related-tour":"enable","single-related-tour-style":"grid","single-related-tour-column-size":"30","single-related-tour-num-fetch":"2","single-related-tour-thumbnail-size":"Portfolio Side Description Large","single-related-tour-price-position":"right-title","single-related-tour-info":"","single-related-tour-excerpt":"none","single-related-tour-excerpt-number":"20","single-related-tour-rating":"enable","system-email-name":"WORDPRESS","admin-enquiry-mail-title":"You received a new enquiry","admin-enquiry-mail-content":"Dear Admin,\n\nYou received a new enquiry from {tour-name}\n\nFrom: {full-name}\n\nEmail: {email-address} \n\nMessage: {your-enquiry}\n\nTravel Date : {travel-date}\n\n#people : {people-number}\n\n","enquiry-mail-title":"You have submitted an enquiry","enquiry-mail-content":"Dear {full-name},\n\nYou have sumiited an enquiry from {tour-name}\n\nMessage: {your-enquiry}\n\nTravel Date : {travel-date}\n\n#people : {people-number}\n\nOur team will contact you back via the email you provided, {email-address} \n\nThank you!","tour-search-item-num-fetch":"9","enable-tour-schema":"enable","tour-schema-price-currency":"","tour-header-overlay-opacity":"25","max-dropdown-room-amount":"5","mobile-login-link":"disable","contact-detail-fields":"","additional-traveller-fields":"{slug=age,title=Age,type=combobox,options=12-15\/ 15-18\/  18+,width=50%}\n{slug=phone,title=Phone,type=text,required=true,width=50%}","search-month-amount":"12","invoice-customer-address":"","single-tour-style":"style-2","update-header-price":"enable","require-adult-to-book-tour":"enable","admin-registration-email-address":"","enable-admin-registration-complete-mail":"enable","admin-registration-complete-mail-title":"New user registration","admin-registration-complete-mail":"<strong>Dear Admin,<\/strong> \n New customer has created an account \n\n Customer\u2019s name : {customer-name} \n Customer\u2019s email : {customer-email} \n Customer\u2019s contact number : {customer-phone}","enable-customer-invoice":"enable","enquiry-form-fields":"{slug=full-name,title=Full Name,type=text,required=true}\n{slug=email-address,title=Email Address,type=email,required=true}\n{slug=travel-date,title=Travel Date,type=datepicker,required=true}\n{slug=people-number,title=People,type=combobox,options=1-5\/5-10\/10-15\/15-20,required=true}\n{slug=your-enquiry,title=Your Enquiry,type=textarea,required=true}\n","single-tour-header-gradient":"top"},"tourmaster_payment":{"stripe-secret-key":"","stripe-publishable-key":"","stripe-currency-code":"usd","paypal-live-mode":"disable","paypal-business-email":"","paypal-currency-code":"USD","payment-method":["booking","paypal","credit-card"],"accepted-credit-card-type":["visa","master-card","american-express","jcb"],"term-of-service-page":"","privacy-statement-page":"","credit-card-payment-gateway":"stripe","paymill-private-key":"","paymill-public-key":"","paymill-currency-code":"usd","authorize-live-mode":"disable","authorize-api-id":"","authorize-transaction-key":"","enable-deposit-payment":"enable","deposit-payment-amount":"30","display-deposit-payment-day":"","paypal-service-fee":"3","hipayprofessional-merchant-login":"","enable-full-payment":"disable","credit-card-service-fee":"3","hipayprofessional-live-mode":"disable","hipayprofessional-merchant-password":"","hipayprofessional-website":"","hipayprofessional-website-category":"","hipayprofessional-website-shopid":"","hipayprofessional-website-logo":"","hipayprofessional-email-notification":"","hipayprofessional-website-rating":"ALL","hipayprofessional-currency-code":"EUR","hipayprofessional-min-amount":"2","hipayprofessional-max-amount":"2500"},"tourmaster_color":{"tourmaster-theme-color":"#234076","tourmaster-rating-color":"#a69371","user-template-background":"#f3f3f3","user-template-navigation-background":"#ffffff","user-template-navigation-title":"#3f3f3f","user-template-navigation-text":"#7d7d7d","user-template-navigation-border":"#e5e5e5","user-template-breadcrumbs-text":"#a5a5a5","user-template-content-block-background":"#ffffff","user-template-content-block-title-link":"#9e9e9e","user-template-content-block-border":"#e8e8e8","user-template-content-block-text":"#545454","tourmaster-input-box-text":"#545454","tourmaster-input-box-background":"#ffffff","tourmaster-input-box-border":"#e6e6e6","tourmaster-upload-box-background":"#f3f3f3","tourmaster-upload-box-text":"#a6a6a6","tourmaster-theme-color-link":"#234076","tourmaster-theme-color-light":"#a69371","tourmaster-single-price-head-background":"#234076","tourmaster-single-price-head-featured-background":"#2c487a","tourmaster-single-price-head-discount-text":"#b5b5b5","tourmaster-remove-color":"#ba4a4a","user-login-submenu-background":"#ffffff","user-login-submenu-border":"#e6e6e6","user-login-submenu-text":"#878787","user-template-my-booking-price-text":"#424242","user-template-my-booking-filter-text":"#a5a5a5","tourmaster-booking-status-text-color":"#acacac","tourmaster-booking-status-pending-color":"#24a04a","tourmaster-booking-status-online-paid":"#cd9b45","tourmaster-booking-receipt-button-background":"#48a198","tourmaster-invoice-title-color":"#121212","tourmaster-invoice-price-head-background":"#f3f3f3","tourmaster-invoice-price-head-text":"#454545","tourmaster-invoice-price-text":"#7b7b7b","tourmaster-invoice-price-amount":"#1e1e1e","tourmaster-input-form-label":"#5c5c5c","tourmaster-datepicker-background":"#f5f5f5","tourmaster-datepicker-border":"#ebebeb","tourmaster-datepicker-head":"#808080","tourmaster-datepicker-enable-background":"#ffffff","tourmaster-datepicker-enable-text":"#5b5b5b","tourmaster-datepicker-disable-text":"#c0c0c0","tourmaster-booking-bar-background":"#ffffff","tourmaster-booking-bar-text":"#4f4f4f","tourmaster-booking-bar-wishlist-background":"#ffffff","tourmaster-booking-bar-wishlist-border":"#ebebeb","tourmaster-booking-bar-summary-title":"#000000","tourmaster-booking-bar-summary-text":"#414141","tourmaster-price-breakdown-color":"#515151","tourmaster-price-breakdown-total-color":"#242424","single-tour-info-background":"#f5f5f5","single-tour-info-text":"#414141","tourmaster-review-title-color":"#272727","tourmaster-review-date-color":"#a3a3a3","tourmaster-payment-complete-background":"#f5f5f5","tourmaster-payment-complete-title":"#262626","tourmaster-payment-complete-border":"#e3e3e3","tourmaster-pagination-background":"#696969","tourmaster-pagination-text":"#f3f3f3","tourmaster-payment-step-icon-background":"#161616","tour-item-frame-background":"#ffffff","tour-price":"#1b1b1b","tour-discount-price":"#aaaaaa","tourmaster-lightbox-background":"#ffffff","tourmaster-lightbox-title":"#0e0e0e","tourmaster-lightbox-form-label":"#5c5c5c","tourmaster-content-navigation-background":"#ffffff","tourmaster-content-navigation-text":"#9a9a9a","tourmaster-content-navigation-active-text":"#1b1b1b","tourmaster-search-frame-background":"#ffffff","tourmaster-single-price-head-background-right":"#234076","tour-item-title-color":"#333333","tour-grid-bottom-price-background":"#e7e7e7","tour-grid-bottom-price-head":"#5c5c5c","tour-grid-bottom-discount-price":"#989898","tourmaster-input-box-background-validate-error":"#fff9f9","search-page-background":"#f3f3f3","tourmaster-search-input-background":"#f3f3f3","tourmaster-search-input-border":"#f3f3f3","tourmaster-search-input-text":"#7f7f7f","tourmaster-search-input-icon":"#383838","tourmaster-tour-review-title":"#313131","tourmaster-tour-review-user-name":"#5f5f5f","tourmaster-search-input-title":"#ffffff","tourmaster-search-input-label":"#383838","tourmaster-booking-status-deposit-paid":"#5b9dd9","tourmaster-price-breakdown-total-color-deposit":"#a1a1a1","payment-service-form-background":"#f5f5f5","payment-service-form-title":"#1a1a1a","payment-service-form-title-border":"#e3e3e3","payment-service-form-label":"#6a6a6a","search-not-found-background":"#f6f6f6","search-not-found-title":"#cccccc","search-not-found-caption":"#a8a8a8","booking-bar-tab-title-background":"#f5f5f5","booking-bar-tab-title-text":"#929292","booking-bar-tab-active-title-text":"#242424","enquery-success-message-background":"#f1f8ff","enquery-success-message-border":"#e1ebfe","enquery-success-message-text":"#758ea8","enquery-failed-message-background":"#fff1f1","enquery-failed-message-border":"#fee1e1","enquery-failed-message-text":"#ffffff","urgency-message-background":"#343434","urgency-message-text":"#a87575","tour-item-order-filterer-background":"#ffffff","tour-item-order-filterer-combobox-background":"#ffffff","tour-item-order-filterer-icon":"#adadad","tourmaster-search-filter-text":"#878787","tourmaster-single-price-head-text":"#1a1a1a","booking-bar-tab-title-divider":"#234076","single-tour-top-gradient":"#0d2e6e"},"tourmaster_plugin":{"font-awesome":"enable","elegant-icon":"enable"}}';
			}else if( $slug == 'main4' ){
				$data = '{"tourmaster_general":{"container-width":"1260px","container-padding":"20px","item-padding":"20px","datepicker-date-format":"d M yy","money-format":"$NUMBER","tax-rate":"9","login-page":"4852","register-page":"4854","user-page":"4833","user-navigation-bottom-text":"<h5>Need Help?<\/5>\n[gdlr_core_space height=\"1px\"]\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"18px\" color=\"#444\" margin-right=\"10px\" ] <span style=\"font-size: 15px; font-weight: 400;\"> 1.828.456.345\n<a href=\"#\">Help@traveltourwp.com<\/a>","payment-page":"","payment-complete-bottom-text":"","search-page":"4858","search-page-num-fetch":"6","search-page-tour-style":"grid-with-frame","search-page-with-frame":"enable","search-page-column-size":"20","search-page-thumbnail-size":"Personnel Thumbnail","search-page-tour-info":["duration-text"],"search-page-excerpt":"none","search-page-excerpt-number":"14","search-page-tour-rating":"enable","invoice-logo":"4890","invoice-logo-width":"250px","invoice-company-name":"GoodLayers Travel Tour","invoice-company-info":"11 Main Street, Kingston, London 22EPH","text":"","textarea":"","combobox":"1","multi-combobox":"","radioimage":"1","checkbox":"disable","tour-header-top-padding":"500px","tour-header-bottom-padding":"45px","single-tour-default-sidebar":"single-tour","payment-page-sidebar":"payment","archive-page":"","search-sidebar":"none","search-sidebar-left":"none","search-sidebar-right":"single-tour","system-email-address":"main@goodlayers.com","admin-email-address":"contact@goodlayers.com","mail-header-logo":"","mail-footer-left":"<span style=\"font-weight: bold\" >Need help?<\/span>\n<a href=\"mailto:help@traveltourwptheme.com\">help@traveltourwptheme.com<\/a>\n1.828.344.234","mail-footer-right":"<span><\/span>\nLogin to <a href=\"http:\/\/demo.goodlayers.com\/traveltour\/login\">your account<\/a>\nCopyright \u00a9 2017, GoodLayers","enable-admin-booking-made-mail":"enable","admin-booking-made-mail-title":"A new booking has been made","admin-booking-made-mail":"<strong>Dear Admin,<\/strong>\nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-admin-payment-submitted-mail":"enable","admin-payment-submitted-mail-title":"A new payment receipt has been submitted","admin-payment-submitted-mail":"<strong>Dear Admin,<\/strong>\nA new payment receipt has been submitted\n\n{tour-name}\n{order-number}\n{travel-date}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-admin-online-payment-made-mail":"enable","admin-online-payment-made-mail-title":"A new booking has been made and successfully paid","admin-online-payment-made-mail":"<strong>Dear Admin,<\/strong>\nA new booking has been made and sucessfully paid.\n\n{payment-method}\n{payment-date}\n{transaction-id}\n{spaces}\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-registration-complete-mail":"enable","registration-complete-mail-title":"Congratulations! Your account has been created","registration-complete-mail":"{header}Congratulations {customer-name}!{\/header}\n\nYour account has been successfully created. Now you can explore new tours and mange booking via the dashboard. You can also review tours and make a wishlist from the dashboard as well.\n\n<a href=\"{profile-page-link}\" >Click here to login to travel tour<\/a>","enable-booking-made-mail":"enable","booking-made-mail-title":"You have made a new booking","booking-made-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-payment-made-mail":"enable","payment-made-mail-title":"Your payment has been successfully processed","payment-made-mail":"<strong>Dear {customer-name}<\/strong>,\nCongratulations! Your payment has been sucessfully processed.\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\nYou can view <a href=\"{invoice-link}\">the receipt here<\/a>","enable-booking-cancelled-mail":"enable","booking-cancelled-mail-title":"Your booking has been cancelled","booking-cancelled-mail":"<strong>Dear {customer-name}<\/strong>,\nWe are here to inform that your booking has been cancelled.\n\n{tour-name}\n{order-number}\n{travel-date}","enable-booking-reject-mail":"enable","booking-reject-mail-title":"Your booking has been rejected","booking-reject-mail":"<strong>Dear {customer-name}<\/strong>,\nWe are sorry to inform that your booking has been rejected. Your booking was rejected because of your payment was not successfully processed or your booking might be in the pending status for too long.\n\n{tour-name}\n{order-number}\n{travel-date}","enable-booking-via-email":"enable","enable-admin-guest-booking-made-mail":"enable","admin-guest-booking-made-mail-title":"A new booking has been made (Guest booked via email)","admin-guest-booking-made-mail":"<strong>Dear Admin,<\/strong> \nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>\n{spaces}\n\nCustomer\u2019s email : {customer-email}\nPlease contact to your customer back for further details.","enable-guest-booking-made-mail":"enable","guest-booking-made-mail-title":"You have made a new booking via email","guest-booking-made-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n{divider}\nOur team will contact you back via the email you provided,\n{customer-email}","price-breakdown-decimal-digit":"2","register-term-of-service-page":"","register-privacy-statement-page":"","user-default-country":"","cancel-booking-day":"","tour-staff-capability":["edit_tour","read_tour","delete_tour","edit_tours","edit_others_tours","publish_tours","read_private_tours","manage_tour_category","manage_tour_tag","manage_tour_filter","edit_coupon","read_coupon","delete_coupon","edit_coupons","edit_others_coupons","publish_coupons","read_private_coupons","manage_tour_order","edit_service","read_service","delete_service","edit_services","edit_others_services","publish_services","read_private_services"],"tour-author-capability":["edit_tour","read_tour","delete_tour","edit_tours","edit_others_tours","publish_tours","read_private_tours","manage_tour_category","manage_tour_tag","manage_tour_filter","edit_coupon","read_coupon","delete_coupon","edit_coupons","edit_others_coupons","publish_coupons","read_private_coupons"],"tour-search-item-style":"medium-with-frame","tour-search-item-thumbnail":"Tour Category","tour-search-item-info":["duration-text","availability"],"tour-search-item-excerpt":"specify-number","tour-search-item-excerpt-number":"14","tour-search-item-rating":"enable","tour-search-order-filterer-grid-style":"grid-with-frame","tour-search-order-filterer-grid-style-thumbnail":"Blog Column Thumbnail","tour-search-order-filterer-grid-style-column":"30","enable-tour-search-filter":"enable","tour-search-fields":["keywords","tour_tag","duration","date","month","min-price","max-price"],"tour-search-rating-field":"enable","tour-search-filters":["tour-age","tour-activity","tour-destination"],"search-not-found-fields":"","search-not-found-style":"column","show-remaining-available-number":"enable","max-dropdown-people-amount":"5","enable-single-sidebar-widget-on-mobile":"enable","enable-single-related-tour":"enable","single-related-tour-style":"grid","single-related-tour-column-size":"30","single-related-tour-num-fetch":"2","single-related-tour-thumbnail-size":"Blog Column Thumbnail","single-related-tour-price-position":"right-title","single-related-tour-info":"","single-related-tour-excerpt":"none","single-related-tour-excerpt-number":"20","single-related-tour-rating":"enable","system-email-name":"WORDPRESS","admin-enquiry-mail-title":"You received a new enquiry","admin-enquiry-mail-content":"Dear Admin,\n\nYou received a new enquiry from {tour-name}\n\nFrom: {full-name}\n\nEmail: {email-address} \n\nMessage: {your-enquiry}\n\n","enquiry-mail-title":"You have submitted an enquiry","enquiry-mail-content":"Dear {full-name},\n\nYou have sumiited an enquiry from {tour-name}\n\nMessage: {your-enquiry}\n\nOur team will contact you back via the email you provided, {email-address} \n\nThank you!","tour-search-item-num-fetch":"9","enable-tour-schema":"enable","tour-schema-price-currency":"","tour-header-overlay-opacity":"15","max-dropdown-room-amount":"10","price-thousand-separator":",","price-decimal-separator":".","included-tax-in-price":"disable","enable-recaptcha":"disable","enable-membership":"enable","mobile-login-link":"disable","block-seat-status":"book","contact-detail-fields":"","additional-traveller-fields":"{slug=age,title=Age,type=combobox,options=12-15\/15-18\/18+ 20,width=50%}\n{slug=phone,title=Phone,type=text,required=true,width=50%}\n","search-page-style":"style-2","search-month-amount":"12","tour-search-default-style":"grid","tour-search-order-filterer-grid-style-type":"style-2","invoice-customer-address":"","single-tour-style":"style-2","mobile-content-read-more":"enable","mobile-booking-bar-position":"bottom","single-tour-header-gradient":"bottom","single-tour-top-gradient-size":"154px","single-tour-bottom-gradient-size":"291px","update-header-price":"enable","require-adult-to-book-tour":"enable","admin-registration-email-address":"contact@goodlayers.com","enable-admin-registration-complete-mail":"enable","admin-registration-complete-mail-title":"New user registration","admin-registration-complete-mail":"<strong>Dear Admin,<\/strong> \n New customer has created an account \n\n Customer\u2019s name : {customer-name} \n Customer\u2019s email : {customer-email} \n Customer\u2019s contact number : {customer-phone}","enable-admin-booking-made-approval-mail":"enable","admin-booking-made-approval-mail-title":"A new booking has been made. Please approve the booking so customer can pay.","admin-booking-made-approval-mail":"<strong>Dear Admin,<\/strong>\nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>\n\nPlease note that this customer can\'t process the payment untill you approvde thier booking.","enable-admin-deposit-payment-made-mail":"enable","admin-deposit-payment-made-mail-title":"New deposit has been successfully paid","admin-deposit-payment-made-mail":"<strong>Dear Admin,<\/strong>\nNew deposit has been successfully paid.\n\n{payment-method}\n{submission-date}\n{transaction-id}\n{submission-amount}\n{spaces}\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-booking-made-approval-mail":"enable","booking-made-approval-mail-title":"You have made a new booking. Please wait for approval before processing payment","booking-made-approval-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\nAt this point, please do nothing yet. \nAfter admin approve your booking, you will get email notification and then you can process payment later.","enable-booking-approve-mail":"enable","booking-approve-mail-title":"Your booking has been approved to process the payment","booking-approve-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\nAdmin has now approved your booking so you can process the payment. \nPlease note that this is not the final approve until you finish the payment.","enable-customer-invoice":"enable","enable-deposit-payment-made-mail":"enable","deposit-payment-made-mail-title":"Your deposit has been successfully processed","deposit-payment-made-mail":"<strong>Dear {customer-name}<\/strong>,\nCongratulations! Your deposit has been sucessfully processed.\n\n{tour-name}\n{order-number}\n{travel-date}\n{submission-amount}\n\nCustomer\'s Note: {customer-note}\n\n{payment-method}\n{submission-date}\n{transaction-id}\n{spaces}\n\nYou can view <a href=\"{invoice-link}\">the receipt here<\/a>","enable-receipt-submission-mail":"enable","receipt-submission-mail-title":"Thank you for payment submission.","receipt-submission-mail":"<strong>Dear {customer-name}<\/strong>,\nThank you for payment submission. After reveiwing, we will get back to you soon. \n\n{tour-name}\n{order-number}\n\n{submission-date}\n{payment-method}\n{submission-amount}\n{transaction-id}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-receipt-approve-mail":"enable","receipt-approve-mail-title":"Your payment submission has been approved.","receipt-approve-mail":"<strong>Dear {customer-name}<\/strong>,\nYour payment submission has been approved. You can make another deposit or the final payment from your dashboard.\n\n{tour-name}\n{order-number}\n\n{submission-date}\n{payment-method}\n{submission-amount}\n{transaction-id}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-receipt-reject-mail":"enable","receipt-reject-mail-title":"Your payment submission has been rejected.","receipt-reject-mail":"<strong>Dear {customer-name}<\/strong>,\nUnfortunately, your payment submission is not valid. Please review your payment receipt and submit again. \n\n{tour-name}\n{order-number}\n\n{submission-date}\n{payment-method}\n{submission-amount}\n{transaction-id}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enquiry-form-fields":"","single-related-tour-grid-style":"style-1","tour-search-item-frame-shadow-size":"25px","tour-search-item-frame-shadow-color":"#0a0a0a","tour-search-item-frame-shadow-opacity":"0.08","enable-cancel-booking-mail":"enable","archive-description":"disable","search-page-tour-grid-style":"style-2","search-page-tour-frame-shadow-size":"25px","search-page-tour-frame-shadow-color":"#0a0a0a","search-page-tour-frame-shadow-opacity":"0.08","enable-guest-booking":"enable","tour-search-filter-state":"enable"},"tourmaster_payment":{"stripe-secret-key":"","stripe-publishable-key":"","stripe-currency-code":"usd","paypal-live-mode":"disable","paypal-business-email":"sandbox1@goodlayers.com","paypal-currency-code":"USD","payment-method":["booking","paypal","credit-card"],"accepted-credit-card-type":["visa","master-card","american-express","jcb"],"term-of-service-page":"","privacy-statement-page":"","credit-card-payment-gateway":"stripe","paymill-private-key":"","paymill-public-key":"","paymill-currency-code":"usd","authorize-live-mode":"disable","authorize-api-id":"","authorize-transaction-key":"","enable-deposit-payment":"enable","deposit-payment-amount":"30","display-deposit-payment-day":"","paypal-service-fee":"3","enable-payment":"enable","payment-admin-approval":"disable","enable-full-payment":"enable","deposit2-payment-amount":"25","deposit3-payment-amount":"20","deposit4-payment-amount":"0","deposit5-payment-amount":"0","credit-card-service-fee":"","hipayprofessional-live-mode":"disable","hipayprofessional-merchant-login":"","hipayprofessional-merchant-password":"","hipayprofessional-website":"","hipayprofessional-website-category":"","hipayprofessional-website-shopid":"","hipayprofessional-website-logo":"","hipayprofessional-email-notification":"","hipayprofessional-website-rating":"ALL","hipayprofessional-currency-code":"EUR","hipayprofessional-min-amount":"2","hipayprofessional-max-amount":"2500"},"tourmaster_color":{"tourmaster-theme-color":"#f97150","tourmaster-rating-color":"#ffa11a","user-template-background":"#f3f3f3","user-template-navigation-background":"#ffffff","user-template-navigation-title":"#3f3f3f","user-template-navigation-text":"#7d7d7d","user-template-navigation-border":"#e5e5e5","user-template-breadcrumbs-text":"#a5a5a5","user-template-content-block-background":"#ffffff","user-template-content-block-title-link":"#9e9e9e","user-template-content-block-border":"#e8e8e8","user-template-content-block-text":"#545454","tourmaster-input-box-text":"#545454","tourmaster-input-box-background":"#ffffff","tourmaster-input-box-border":"#e5e5e5","tourmaster-upload-box-background":"#f3f3f3","tourmaster-upload-box-text":"#a6a6a6","tourmaster-theme-color-link":"#f97150","tourmaster-theme-color-light":"#f97150","tourmaster-single-price-head-background":"#f97150","tourmaster-single-price-head-featured-background":"#f97150","tourmaster-single-price-head-discount-text":"#a3a3a3","tourmaster-remove-color":"#ba4a4a","user-login-submenu-background":"#ffffff","user-login-submenu-border":"#e6e6e6","user-login-submenu-text":"#878787","user-template-my-booking-price-text":"#424242","user-template-my-booking-filter-text":"#a5a5a5","tourmaster-booking-status-text-color":"#acacac","tourmaster-booking-status-pending-color":"#24a04a","tourmaster-booking-status-online-paid":"#cd9b45","tourmaster-booking-receipt-button-background":"#48a198","tourmaster-invoice-title-color":"#121212","tourmaster-invoice-price-head-background":"#f3f3f3","tourmaster-invoice-price-head-text":"#454545","tourmaster-invoice-price-text":"#7b7b7b","tourmaster-invoice-price-amount":"#1e1e1e","tourmaster-input-form-label":"#5c5c5c","tourmaster-datepicker-background":"#f5f5f5","tourmaster-datepicker-border":"#ebebeb","tourmaster-datepicker-head":"#808080","tourmaster-datepicker-enable-background":"#ffffff","tourmaster-datepicker-enable-text":"#5b5b5b","tourmaster-datepicker-disable-text":"#c0c0c0","tourmaster-booking-bar-background":"#ffffff","tourmaster-booking-bar-text":"#333333","tourmaster-booking-bar-wishlist-background":"#fbfbfb","tourmaster-booking-bar-wishlist-border":"#ebebeb","tourmaster-booking-bar-summary-title":"#000000","tourmaster-booking-bar-summary-text":"#414141","tourmaster-price-breakdown-color":"#515151","tourmaster-price-breakdown-total-color":"#242424","single-tour-info-background":"#f5f5f5","single-tour-info-text":"#414141","tourmaster-review-title-color":"#272727","tourmaster-review-date-color":"#a3a3a3","tourmaster-payment-complete-background":"#f5f5f5","tourmaster-payment-complete-title":"#262626","tourmaster-payment-complete-border":"#e3e3e3","tourmaster-pagination-background":"#696969","tourmaster-pagination-text":"#f3f3f3","tourmaster-payment-step-icon-background":"#161616","tour-item-frame-background":"#ffffff","tour-price":"#f97150","tour-discount-price":"#a7a7a7","tourmaster-lightbox-background":"#ffffff","tourmaster-lightbox-title":"#0e0e0e","tourmaster-lightbox-form-label":"#5c5c5c","tourmaster-content-navigation-background":"#ffffff","tourmaster-content-navigation-text":"#9a9a9a","tourmaster-content-navigation-active-text":"#1b1b1b","tourmaster-search-frame-background":"#ffffff","tourmaster-single-price-head-background-right":"#f97150","tour-item-title-color":"#333333","tour-grid-bottom-price-background":"#e7e7e7","tour-grid-bottom-price-head":"#5c5c5c","tour-grid-bottom-discount-price":"#989898","tourmaster-input-box-background-validate-error":"#fff9f9","search-page-background":"#ffffff","tourmaster-search-input-background":"#ffffff","tourmaster-search-input-border":"#e5e5e5","tourmaster-search-input-text":"#7f7f7f","tourmaster-search-input-icon":"#383838","tourmaster-tour-review-title":"#313131","tourmaster-tour-review-user-name":"#5f5f5f","tourmaster-search-input-title":"#ffffff","tourmaster-search-input-label":"#383838","tourmaster-booking-status-deposit-paid":"#5b9dd9","tourmaster-price-breakdown-total-color-deposit":"#a1a1a1","payment-service-form-background":"#f5f5f5","payment-service-form-title":"#1a1a1a","payment-service-form-title-border":"#e3e3e3","payment-service-form-label":"#6a6a6a","search-not-found-background":"#f6f6f6","search-not-found-title":"#cccccc","search-not-found-caption":"#a8a8a8","booking-bar-tab-title-background":"#f5f5f5","booking-bar-tab-title-text":"#929292","booking-bar-tab-active-title-text":"#242424","enquery-success-message-background":"#f1f8ff","enquery-success-message-border":"#e1ebfe","enquery-success-message-text":"#758ea8","enquery-failed-message-background":"#fff1f1","enquery-failed-message-border":"#fee1e1","enquery-failed-message-text":"#ffffff","urgency-message-background":"#343434","urgency-message-text":"#a87575","tour-item-order-filterer-background":"#ffffff","tour-item-order-filterer-combobox-background":"#ffffff","tour-item-order-filterer-icon":"#adadad","tourmaster-search-filter-text":"#878787","tourmaster-single-price-head-text":"#1a1a1a","tourmaster-booking-status-wait-for-approval":"#e0724e","tourmaster-payment-title-overlay":"#000000","single-tour-top-gradient":"#000","single-tour-top-gradient-max-opacity":"1","single-tour-bottom-gradient-max-opacity":"0.6","booking-bar-tab-title-divider":"#f97150","tourmaster-checkbox-box-border":"#cccccc","tourmaster-search-item-title":"#f97150","tourmaster-search-item-icon":"#212121","tour-item-title-hover-color":"#333333","tourmaster-payment-title-Color":"#ffffff","tourmaster-payment-title-overlay-opacity":"0.5","tourmaster-payment-step-title-Color":"#ffffff"},"tourmaster_plugin":{"font-awesome":"enable","elegant-icon":"enable"}}';
			}else if( $slug == 'hiking' ){
				$data = '{"tourmaster_general":{"container-width":"1320px","container-padding":"20px","item-padding":"20px","datepicker-date-format":"d M yy","money-format":"$NUMBER","tax-rate":"9","login-page":"4852","register-page":"4854","user-page":"4833","user-navigation-bottom-text":"<h5>Need Help?<\/5>\n[gdlr_core_space height=\"1px\"]\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"18px\" color=\"#444\" margin-right=\"10px\" ] <span style=\"font-size: 15px; font-weight: 400;\"> 1.828.456.345\n<a href=\"#\">Help@traveltourwp.com<\/a>","payment-page":"","payment-complete-bottom-text":"","search-page":"4858","search-page-num-fetch":"6","search-page-tour-style":"grid-with-frame","search-page-with-frame":"enable","search-page-column-size":"20","search-page-thumbnail-size":"Personnel Thumbnail","search-page-tour-info":["duration-text"],"search-page-excerpt":"none","search-page-excerpt-number":"14","search-page-tour-rating":"enable","invoice-logo":"4890","invoice-logo-width":"250px","invoice-company-name":"GoodLayers Travel Tour","invoice-company-info":"11 Main Street, Kingston, London 22EPH","text":"","textarea":"","combobox":"1","multi-combobox":"","radioimage":"1","checkbox":"disable","tour-header-top-padding":"281px","tour-header-bottom-padding":"50px","single-tour-default-sidebar":"single-tour","payment-page-sidebar":"payment","archive-page":"","search-sidebar":"none","search-sidebar-left":"none","search-sidebar-right":"single-tour","system-email-address":"","admin-email-address":"","mail-header-logo":"5384","mail-footer-left":"<span style=\"font-weight: bold\" >Need help?<\/span>\n<a href=\"mailto:help@traveltourwptheme.com\">help@traveltourwptheme.com<\/a>\n1.828.344.234","mail-footer-right":"<span><\/span>\nLogin to <a href=\"http:\/\/demo.goodlayers.com\/traveltour\/login\">your account<\/a>\nCopyright \u00a9 2017, GoodLayers","enable-admin-booking-made-mail":"enable","admin-booking-made-mail-title":"A new booking has been made","admin-booking-made-mail":"<strong>Dear Admin,<\/strong>\nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n{traveller-amount}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-admin-payment-submitted-mail":"enable","admin-payment-submitted-mail-title":"A new payment receipt has been submitted","admin-payment-submitted-mail":"<strong>Dear Admin,<\/strong>\nA new payment receipt has been submitted\n\n{tour-name}\n{order-number}\n{travel-date}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-admin-online-payment-made-mail":"enable","admin-online-payment-made-mail-title":"A new booking has been made and successfully paid","admin-online-payment-made-mail":"<strong>Dear Admin,<\/strong>\nA new booking has been made and sucessfully paid.\n\n{payment-method}\n{payment-date}\n{transaction-id}\n{spaces}\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-registration-complete-mail":"enable","registration-complete-mail-title":"Congratulations! Your account has been created","registration-complete-mail":"{header}Congratulations {customer-name}!{\/header}\n\nYour account has been successfully created. Now you can explore new tours and mange booking via the dashboard. You can also review tours and make a wishlist from the dashboard as well.\n\n<a href=\"{profile-page-link}\" >Click here to login to travel tour<\/a>","enable-booking-made-mail":"enable","booking-made-mail-title":"You have made a new booking","booking-made-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-payment-made-mail":"enable","payment-made-mail-title":"Your payment has been successfully processed","payment-made-mail":"<strong>Dear {customer-name}<\/strong>,\nCongratulations! Your payment has been sucessfully processed.\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\nYou can view <a href=\"{invoice-link}\">the receipt here<\/a>","enable-booking-cancelled-mail":"enable","booking-cancelled-mail-title":"Your booking has been cancelled","booking-cancelled-mail":"<strong>Dear {customer-name}<\/strong>,\nWe are here to inform that your booking has been cancelled.\n\n{tour-name}\n{order-number}\n{travel-date}","enable-booking-reject-mail":"enable","booking-reject-mail-title":"Your booking has been rejected","booking-reject-mail":"<strong>Dear {customer-name}<\/strong>,\nWe are sorry to inform that your booking has been rejected. Your booking was rejected because of your payment was not successfully processed or your booking might be in the pending status for too long.\n\n{tour-name}\n{order-number}\n{travel-date}","enable-booking-via-email":"enable","enable-admin-guest-booking-made-mail":"enable","admin-guest-booking-made-mail-title":"A new booking has been made (Guest booked via email)","admin-guest-booking-made-mail":"<strong>Dear Admin,<\/strong> \nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>\n{spaces}\n\nCustomer\u2019s email : {customer-email}\nPlease contact to your customer back for further details.","enable-guest-booking-made-mail":"enable","guest-booking-made-mail-title":"You have made a new booking via email","guest-booking-made-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n{divider}\nOur team will contact you back via the email you provided,\n{customer-email}","price-breakdown-decimal-digit":"2","register-term-of-service-page":"5389","register-privacy-statement-page":"5389","user-default-country":"United States of America (USA)","cancel-booking-day":"","tour-staff-capability":["edit_tour","read_tour","delete_tour","edit_tours","edit_others_tours","publish_tours","read_private_tours","manage_tour_category","manage_tour_tag","manage_tour_filter","edit_coupon","read_coupon","delete_coupon","edit_coupons","edit_others_coupons","publish_coupons","read_private_coupons","manage_tour_order","edit_service","read_service","delete_service","edit_services","edit_others_services","publish_services","read_private_services"],"tour-author-capability":["edit_tour","read_tour","delete_tour","edit_tours","edit_others_tours","publish_tours","read_private_tours","manage_tour_category","manage_tour_tag","manage_tour_filter","edit_coupon","read_coupon","delete_coupon","edit_coupons","edit_others_coupons","publish_coupons","read_private_coupons"],"tour-search-item-style":"medium-with-frame","tour-search-item-thumbnail":"Tour Category","tour-search-item-info":["duration-text","availability"],"tour-search-item-excerpt":"specify-number","tour-search-item-excerpt-number":"14","tour-search-item-rating":"enable","tour-search-order-filterer-grid-style":"grid-with-frame","tour-search-order-filterer-grid-style-thumbnail":"Blog Column Thumbnail","tour-search-order-filterer-grid-style-column":"30","enable-tour-search-filter":"enable","tour-search-fields":["keywords","tour_category","duration","date","month","min-price","max-price"],"tour-search-rating-field":"enable","tour-search-filters":["tour-age","tour-activity","tour-destination"],"search-not-found-fields":"","search-not-found-style":"column","show-remaining-available-number":"enable","max-dropdown-people-amount":"6","enable-single-sidebar-widget-on-mobile":"enable","enable-single-related-tour":"enable","single-related-tour-style":"grid","single-related-tour-column-size":"30","single-related-tour-num-fetch":"2","single-related-tour-thumbnail-size":"Portfolio Side Description Large","single-related-tour-price-position":"right-title","single-related-tour-info":"","single-related-tour-excerpt":"none","single-related-tour-excerpt-number":"20","single-related-tour-rating":"enable","system-email-name":"WORDPRESS","admin-enquiry-mail-title":"You received a new enquiry","admin-enquiry-mail-content":"Dear Admin,\n\nYou received a new enquiry from {tour-name}\n\nFrom: {full-name}\n\nEmail: {email-address} \n\nMessage: {your-enquiry}\n\nTravel Date : {travel-date}\n\n#people : {people-number}\n\n","enquiry-mail-title":"You have submitted an enquiry","enquiry-mail-content":"Dear {full-name},\n\nYou have sumiited an enquiry from {tour-name}\n\nMessage: {your-enquiry}\n\nTravel Date : {travel-date}\n\n#people : {people-number}\n\nOur team will contact you back via the email you provided, {email-address} \n\nThank you!","tour-search-item-num-fetch":"9","enable-tour-schema":"enable","tour-schema-price-currency":"","tour-header-overlay-opacity":"0","max-dropdown-room-amount":"5","mobile-login-link":"disable","contact-detail-fields":"","additional-traveller-fields":"{slug=age,title=Age,type=combobox,options=12-15\/ 15-18\/  18+,width=50%}\n{slug=phone,title=Phone,type=text,required=true,width=50%}","search-month-amount":"12","invoice-customer-address":"","single-tour-style":"style-2","update-header-price":"enable","require-adult-to-book-tour":"enable","admin-registration-email-address":"","enable-admin-registration-complete-mail":"enable","admin-registration-complete-mail-title":"New user registration","admin-registration-complete-mail":"<strong>Dear Admin,<\/strong> \n New customer has created an account \n\n Customer\u2019s name : {customer-name} \n Customer\u2019s email : {customer-email} \n Customer\u2019s contact number : {customer-phone}","enable-customer-invoice":"enable","enquiry-form-fields":"{slug=full-name,title=Full Name,type=text,required=true}\n{slug=email-address,title=Email Address,type=email,required=true}\n{slug=travel-date,title=Travel Date,type=datepicker,required=true}\n{slug=people-number,title=People,type=combobox,options=1-5\/5-10\/10-15\/15-20,required=true}\n{slug=your-enquiry,title=Your Enquiry,type=textarea,required=true}\n","single-tour-header-gradient":"top","price-thousand-separator":",","price-decimal-separator":".","included-tax-in-price":"disable","enable-recaptcha":"disable","enable-membership":"enable","block-seat-status":"book","search-page-style":"style-2","tour-search-default-style":"grid","tour-search-item-frame-shadow-size":"25px","tour-search-item-frame-shadow-color":"#000000","tour-search-item-frame-shadow-opacity":"0.08","tour-search-order-filterer-grid-style-type":"style-2","mobile-content-read-more":"enable","mobile-booking-bar-position":"bottom","single-tour-top-gradient-size":"329px","single-tour-bottom-gradient-size":"300px","single-related-tour-grid-style":"style-1","enable-admin-booking-made-approval-mail":"enable","admin-booking-made-approval-mail-title":"A new booking has been made. Please approve the booking so customer can pay.","admin-booking-made-approval-mail":"<strong>Dear Admin,<\/strong>\nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>\n\nPlease note that this customer can\'t process the payment untill you approvde thier booking.","enable-admin-deposit-payment-made-mail":"disable","admin-deposit-payment-made-mail-title":"New deposit has been successfully paid","admin-deposit-payment-made-mail":"<strong>Dear Admin,<\/strong>\nNew deposit has been successfully paid.\n\n{payment-method}\n{submission-date}\n{transaction-id}\n{submission-amount}\n{spaces}\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-booking-made-approval-mail":"disable","booking-made-approval-mail-title":"You have made a new booking. Please wait for approval before processing payment","booking-made-approval-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\nAt this point, please do nothing yet. \nAfter admin approve your booking, you will get email notification and then you can process payment later.","enable-booking-approve-mail":"disable","booking-approve-mail-title":"Your booking has been approved to process the payment","booking-approve-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\nAdmin has now approved your booking so you can process the payment. \nPlease note that this is not the final approve until you finish the payment.","enable-deposit-payment-made-mail":"disable","deposit-payment-made-mail-title":"Your deposit has been successfully processed","deposit-payment-made-mail":"<strong>Dear {customer-name}<\/strong>,\nCongratulations! Your deposit has been sucessfully processed.\n\n{tour-name}\n{order-number}\n{travel-date}\n{submission-amount}\n\nCustomer\'s Note: {customer-note}\n\n{payment-method}\n{submission-date}\n{transaction-id}\n{spaces}\n\nYou can view <a href=\"{invoice-link}\">the receipt here<\/a>","enable-receipt-submission-mail":"enable","receipt-submission-mail-title":"Thank you for payment submission.","receipt-submission-mail":"<strong>Dear {customer-name}<\/strong>,\nThank you for payment submission. After reveiwing, we will get back to you soon. \n\n{tour-name}\n{order-number}\n\n{submission-date}\n{payment-method}\n{submission-amount}\n{transaction-id}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-receipt-approve-mail":"enable","receipt-approve-mail-title":"Your payment submission has been approved.","receipt-approve-mail":"<strong>Dear {customer-name}<\/strong>,\nYour payment submission has been approved. You can make another deposit or the final payment from your dashboard.\n\n{tour-name}\n{order-number}\n\n{submission-date}\n{payment-method}\n{submission-amount}\n{transaction-id}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-receipt-reject-mail":"enable","receipt-reject-mail-title":"Your payment submission has been rejected.","receipt-reject-mail":"<strong>Dear {customer-name}<\/strong>,\nUnfortunately, your payment submission is not valid. Please review your payment receipt and submit again. \n\n{tour-name}\n{order-number}\n\n{submission-date}\n{payment-method}\n{submission-amount}\n{transaction-id}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-cancel-booking-mail":"enable","archive-description":"disable","search-page-tour-grid-style":"style-2","search-page-tour-frame-shadow-size":"25px","search-page-tour-frame-shadow-color":"#000000","search-page-tour-frame-shadow-opacity":"0.08","enable-guest-booking":"enable","tour-search-filter-state":"enable"},"tourmaster_payment":{"stripe-secret-key":"","stripe-publishable-key":"","stripe-currency-code":"usd","paypal-live-mode":"disable","paypal-business-email":"sandbox1@goodlayers.com","paypal-currency-code":"USD","payment-method":["booking","paypal","credit-card"],"accepted-credit-card-type":["visa","master-card","american-express","jcb"],"term-of-service-page":"","privacy-statement-page":"","credit-card-payment-gateway":"stripe","paymill-private-key":"","paymill-public-key":"","paymill-currency-code":"usd","authorize-live-mode":"disable","authorize-api-id":"","authorize-transaction-key":"","enable-deposit-payment":"enable","deposit-payment-amount":"30","display-deposit-payment-day":"","paypal-service-fee":"3","hipayprofessional-merchant-login":"","enable-full-payment":"disable","credit-card-service-fee":"3","hipayprofessional-live-mode":"disable","hipayprofessional-merchant-password":"","hipayprofessional-website":"","hipayprofessional-website-category":"","hipayprofessional-website-shopid":"","hipayprofessional-website-logo":"","hipayprofessional-email-notification":"","hipayprofessional-website-rating":"ALL","hipayprofessional-currency-code":"EUR","hipayprofessional-min-amount":"2","hipayprofessional-max-amount":"2500","enable-payment":"enable","payment-admin-approval":"disable","deposit2-payment-amount":"0","deposit3-payment-amount":"0","deposit4-payment-amount":"0","deposit5-payment-amount":"0"},"tourmaster_color":{"tourmaster-theme-color":"#234076","tourmaster-rating-color":"#ffa11a","user-template-background":"#f3f3f3","user-template-navigation-background":"#ffffff","user-template-navigation-title":"#3f3f3f","user-template-navigation-text":"#7d7d7d","user-template-navigation-border":"#e5e5e5","user-template-breadcrumbs-text":"#a5a5a5","user-template-content-block-background":"#ffffff","user-template-content-block-title-link":"#9e9e9e","user-template-content-block-border":"#e8e8e8","user-template-content-block-text":"#545454","tourmaster-input-box-text":"#545454","tourmaster-input-box-background":"#ffffff","tourmaster-input-box-border":"#e6e6e6","tourmaster-upload-box-background":"#f3f3f3","tourmaster-upload-box-text":"#a6a6a6","tourmaster-theme-color-link":"#234076","tourmaster-theme-color-light":"#234076","tourmaster-single-price-head-background":"#234076","tourmaster-single-price-head-featured-background":"#2c487a","tourmaster-single-price-head-discount-text":"#b5b5b5","tourmaster-remove-color":"#ba4a4a","user-login-submenu-background":"#ffffff","user-login-submenu-border":"#e6e6e6","user-login-submenu-text":"#878787","user-template-my-booking-price-text":"#424242","user-template-my-booking-filter-text":"#a5a5a5","tourmaster-booking-status-text-color":"#acacac","tourmaster-booking-status-pending-color":"#24a04a","tourmaster-booking-status-online-paid":"#cd9b45","tourmaster-booking-receipt-button-background":"#48a198","tourmaster-invoice-title-color":"#121212","tourmaster-invoice-price-head-background":"#f3f3f3","tourmaster-invoice-price-head-text":"#454545","tourmaster-invoice-price-text":"#7b7b7b","tourmaster-invoice-price-amount":"#1e1e1e","tourmaster-input-form-label":"#5c5c5c","tourmaster-datepicker-background":"#f5f5f5","tourmaster-datepicker-border":"#ebebeb","tourmaster-datepicker-head":"#808080","tourmaster-datepicker-enable-background":"#ffffff","tourmaster-datepicker-enable-text":"#5b5b5b","tourmaster-datepicker-disable-text":"#c0c0c0","tourmaster-booking-bar-background":"#ffffff","tourmaster-booking-bar-text":"#4f4f4f","tourmaster-booking-bar-wishlist-background":"#ffffff","tourmaster-booking-bar-wishlist-border":"#ebebeb","tourmaster-booking-bar-summary-title":"#000000","tourmaster-booking-bar-summary-text":"#414141","tourmaster-price-breakdown-color":"#515151","tourmaster-price-breakdown-total-color":"#242424","single-tour-info-background":"#f5f5f5","single-tour-info-text":"#414141","tourmaster-review-title-color":"#272727","tourmaster-review-date-color":"#a3a3a3","tourmaster-payment-complete-background":"#f5f5f5","tourmaster-payment-complete-title":"#262626","tourmaster-payment-complete-border":"#e3e3e3","tourmaster-pagination-background":"#696969","tourmaster-pagination-text":"#f3f3f3","tourmaster-payment-step-icon-background":"#161616","tour-item-frame-background":"#ffffff","tour-price":"#1b1b1b","tour-discount-price":"#aaaaaa","tourmaster-lightbox-background":"#ffffff","tourmaster-lightbox-title":"#0e0e0e","tourmaster-lightbox-form-label":"#5c5c5c","tourmaster-content-navigation-background":"#ffffff","tourmaster-content-navigation-text":"#9a9a9a","tourmaster-content-navigation-active-text":"#1b1b1b","tourmaster-search-frame-background":"#ffffff","tourmaster-single-price-head-background-right":"#234076","tour-item-title-color":"#333333","tour-grid-bottom-price-background":"#e7e7e7","tour-grid-bottom-price-head":"#5c5c5c","tour-grid-bottom-discount-price":"#989898","tourmaster-input-box-background-validate-error":"#fff9f9","search-page-background":"#ffffff","tourmaster-search-input-background":"#ffffff","tourmaster-search-input-border":"#e5e5e5","tourmaster-search-input-text":"#7f7f7f","tourmaster-search-input-icon":"#383838","tourmaster-tour-review-title":"#313131","tourmaster-tour-review-user-name":"#5f5f5f","tourmaster-search-input-title":"#ffffff","tourmaster-search-input-label":"#383838","tourmaster-booking-status-deposit-paid":"#5b9dd9","tourmaster-price-breakdown-total-color-deposit":"#a1a1a1","payment-service-form-background":"#f5f5f5","payment-service-form-title":"#1a1a1a","payment-service-form-title-border":"#e3e3e3","payment-service-form-label":"#6a6a6a","search-not-found-background":"#f6f6f6","search-not-found-title":"#cccccc","search-not-found-caption":"#a8a8a8","booking-bar-tab-title-background":"#f5f5f5","booking-bar-tab-title-text":"#929292","booking-bar-tab-active-title-text":"#242424","enquery-success-message-background":"#f1f8ff","enquery-success-message-border":"#e1ebfe","enquery-success-message-text":"#758ea8","enquery-failed-message-background":"#fff1f1","enquery-failed-message-border":"#fee1e1","enquery-failed-message-text":"#ffffff","urgency-message-background":"#343434","urgency-message-text":"#a87575","tour-item-order-filterer-background":"#ffffff","tour-item-order-filterer-combobox-background":"#ffffff","tour-item-order-filterer-icon":"#adadad","tourmaster-search-filter-text":"#878787","tourmaster-single-price-head-text":"#1a1a1a","booking-bar-tab-title-divider":"#234076","single-tour-top-gradient":"#ffffff","tourmaster-booking-status-wait-for-approval":"#e0724e","tourmaster-checkbox-box-border":"#cccccc","tourmaster-payment-title-overlay":"#ffffff","single-tour-top-gradient-max-opacity":"1","single-tour-bottom-gradient-max-opacity":"1","tourmaster-search-item-title":"#133a67","tourmaster-search-item-icon":"#191919","tour-item-title-hover-color":"#444444","tourmaster-payment-title-Color":"#1e1e1e","tourmaster-payment-title-overlay-opacity":"0.75","tourmaster-payment-step-title-Color":"#133a67"},"tourmaster_plugin":{"font-awesome":"enable","elegant-icon":"enable"}}';
			}else if( $slug == 'golf' ){
				$data = '{"tourmaster_general":{"container-width":"1260px","container-padding":"20px","item-padding":"20px","datepicker-date-format":"d M yy","money-format":"$NUMBER","tax-rate":"9","login-page":"4852","register-page":"4854","user-page":"4833","user-navigation-bottom-text":"<h5>Need Help?<\/5>\n[gdlr_core_space height=\"1px\"]\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"18px\" color=\"#444\" margin-right=\"10px\" ] <span style=\"font-size: 15px; font-weight: 400;\"> 1.828.456.345\n<a href=\"#\">Help@traveltourwp.com<\/a>","payment-page":"","payment-complete-bottom-text":"","search-page":"4858","search-page-num-fetch":"6","search-page-tour-style":"grid-with-frame","search-page-with-frame":"enable","search-page-column-size":"20","search-page-thumbnail-size":"Personnel Thumbnail","search-page-tour-info":["duration-text"],"search-page-excerpt":"none","search-page-excerpt-number":"14","search-page-tour-rating":"enable","invoice-logo":"4890","invoice-logo-width":"250px","invoice-company-name":"GoodLayers Travel Tour","invoice-company-info":"11 Main Street, Kingston, London 22EPH","text":"","textarea":"","combobox":"1","multi-combobox":"","radioimage":"1","checkbox":"disable","tour-header-top-padding":"605px","tour-header-bottom-padding":"45px","single-tour-default-sidebar":"single-tour","payment-page-sidebar":"payment","archive-page":"","search-sidebar":"none","search-sidebar-left":"none","search-sidebar-right":"single-tour","system-email-address":"mail@goodlayers.com","admin-email-address":"contact@goodlayers.com","mail-header-logo":"","mail-footer-left":"<span style=\"font-weight: bold\" >Need help?<\/span>\n<a href=\"mailto:help@traveltourwptheme.com\">help@traveltourwptheme.com<\/a>\n1.828.344.234","mail-footer-right":"<span><\/span>\nLogin to <a href=\"http:\/\/demo.goodlayers.com\/traveltour\/login\">your account<\/a>\nCopyright \u00a9 2017, GoodLayers","enable-admin-booking-made-mail":"enable","admin-booking-made-mail-title":"A new booking has been made","admin-booking-made-mail":"<strong>Dear Admin,<\/strong>\nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-admin-payment-submitted-mail":"enable","admin-payment-submitted-mail-title":"A new payment receipt has been submitted","admin-payment-submitted-mail":"<strong>Dear Admin,<\/strong>\nA new payment receipt has been submitted\n\n{tour-name}\n{order-number}\n{travel-date}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-admin-online-payment-made-mail":"enable","admin-online-payment-made-mail-title":"A new booking has been made and successfully paid","admin-online-payment-made-mail":"<strong>Dear Admin,<\/strong>\nA new booking has been made and sucessfully paid.\n\n{payment-method}\n{payment-date}\n{transaction-id}\n{spaces}\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-registration-complete-mail":"enable","registration-complete-mail-title":"Congratulations! Your account has been created","registration-complete-mail":"{header}Congratulations {customer-name}!{\/header}\n\nYour account has been successfully created. Now you can explore new tours and mange booking via the dashboard. You can also review tours and make a wishlist from the dashboard as well.\n\n<a href=\"{profile-page-link}\" >Click here to login to travel tour<\/a>","enable-booking-made-mail":"enable","booking-made-mail-title":"You have made a new booking","booking-made-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-payment-made-mail":"enable","payment-made-mail-title":"Your payment has been successfully processed","payment-made-mail":"<strong>Dear {customer-name}<\/strong>,\nCongratulations! Your payment has been sucessfully processed.\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\nYou can view <a href=\"{invoice-link}\">the receipt here<\/a>","enable-booking-cancelled-mail":"enable","booking-cancelled-mail-title":"Your booking has been cancelled","booking-cancelled-mail":"<strong>Dear {customer-name}<\/strong>,\nWe are here to inform that your booking has been cancelled.\n\n{tour-name}\n{order-number}\n{travel-date}","enable-booking-reject-mail":"enable","booking-reject-mail-title":"Your booking has been rejected","booking-reject-mail":"<strong>Dear {customer-name}<\/strong>,\nWe are sorry to inform that your booking has been rejected. Your booking was rejected because of your payment was not successfully processed or your booking might be in the pending status for too long.\n\n{tour-name}\n{order-number}\n{travel-date}","enable-booking-via-email":"enable","enable-admin-guest-booking-made-mail":"enable","admin-guest-booking-made-mail-title":"A new booking has been made (Guest booked via email)","admin-guest-booking-made-mail":"<strong>Dear Admin,<\/strong> \nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>\n{spaces}\n\nCustomer\u2019s email : {customer-email}\nPlease contact to your customer back for further details.","enable-guest-booking-made-mail":"enable","guest-booking-made-mail-title":"You have made a new booking via email","guest-booking-made-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n{divider}\nOur team will contact you back via the email you provided,\n{customer-email}","price-breakdown-decimal-digit":"2","register-term-of-service-page":"","register-privacy-statement-page":"","user-default-country":"Italy","cancel-booking-day":"","tour-staff-capability":["edit_tour","read_tour","delete_tour","edit_tours","edit_others_tours","publish_tours","read_private_tours","manage_tour_category","manage_tour_tag","manage_tour_filter","edit_coupon","read_coupon","delete_coupon","edit_coupons","edit_others_coupons","publish_coupons","read_private_coupons","manage_tour_order","edit_service","read_service","delete_service","edit_services","edit_others_services","publish_services","read_private_services"],"tour-author-capability":["edit_tour","read_tour","delete_tour","edit_tours","edit_others_tours","publish_tours","read_private_tours","manage_tour_category","manage_tour_tag","manage_tour_filter","edit_coupon","read_coupon","delete_coupon","edit_coupons","edit_others_coupons","publish_coupons","read_private_coupons"],"tour-search-item-style":"medium-with-frame","tour-search-item-thumbnail":"Tour Category","tour-search-item-info":["duration-text","availability"],"tour-search-item-excerpt":"specify-number","tour-search-item-excerpt-number":"14","tour-search-item-rating":"enable","tour-search-order-filterer-grid-style":"grid-with-frame","tour-search-order-filterer-grid-style-thumbnail":"Blog Column Thumbnail","tour-search-order-filterer-grid-style-column":"30","enable-tour-search-filter":"enable","tour-search-fields":["keywords","tour_tag","duration","date","month","min-price","max-price"],"tour-search-rating-field":"enable","tour-search-filters":["tour-activity","tour-destination"],"search-not-found-fields":"","search-not-found-style":"column","show-remaining-available-number":"enable","max-dropdown-people-amount":"5","enable-single-sidebar-widget-on-mobile":"enable","enable-single-related-tour":"enable","single-related-tour-style":"grid","single-related-tour-column-size":"30","single-related-tour-num-fetch":"2","single-related-tour-thumbnail-size":"Blog Column Thumbnail","single-related-tour-price-position":"right-title","single-related-tour-info":"","single-related-tour-excerpt":"none","single-related-tour-excerpt-number":"20","single-related-tour-rating":"enable","system-email-name":"WORDPRESS","admin-enquiry-mail-title":"You received a new enquiry","admin-enquiry-mail-content":"Dear Admin,\n\nYou received a new enquiry from {tour-name}\n\nFrom: {full-name}\n\nEmail: {email-address} \n\nMessage: {your-enquiry}\n\n","enquiry-mail-title":"You have submitted an enquiry","enquiry-mail-content":"Dear {full-name},\n\nYou have sumiited an enquiry from {tour-name}\n\nMessage: {your-enquiry}\n\nOur team will contact you back via the email you provided, {email-address} \n\nThank you!","tour-search-item-num-fetch":"9","enable-tour-schema":"enable","tour-schema-price-currency":"","tour-header-overlay-opacity":"15","max-dropdown-room-amount":"10","price-thousand-separator":",","price-decimal-separator":".","included-tax-in-price":"disable","enable-recaptcha":"disable","enable-membership":"enable","mobile-login-link":"disable","block-seat-status":"book","contact-detail-fields":"","additional-traveller-fields":"","search-page-style":"style-2","search-month-amount":"12","tour-search-default-style":"grid","tour-search-order-filterer-grid-style-type":"style-2","invoice-customer-address":"","single-tour-style":"style-2","mobile-content-read-more":"enable","mobile-booking-bar-position":"bottom","single-tour-header-gradient":"both","single-tour-top-gradient-size":"154px","single-tour-bottom-gradient-size":"291px","update-header-price":"enable","require-adult-to-book-tour":"enable","admin-registration-email-address":"contact@goodlayers.com","enable-admin-registration-complete-mail":"enable","admin-registration-complete-mail-title":"New user registration","admin-registration-complete-mail":"<strong>Dear Admin,<\/strong> \n New customer has created an account \n\n Customer\u2019s name : {customer-name} \n Customer\u2019s email : {customer-email} \n Customer\u2019s contact number : {customer-phone}","enable-admin-booking-made-approval-mail":"enable","admin-booking-made-approval-mail-title":"A new booking has been made. Please approve the booking so customer can pay.","admin-booking-made-approval-mail":"<strong>Dear Admin,<\/strong>\nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>\n\nPlease note that this customer can\'t process the payment untill you approvde thier booking.","enable-admin-deposit-payment-made-mail":"enable","admin-deposit-payment-made-mail-title":"New deposit has been successfully paid","admin-deposit-payment-made-mail":"<strong>Dear Admin,<\/strong>\nNew deposit has been successfully paid.\n\n{payment-method}\n{submission-date}\n{transaction-id}\n{submission-amount}\n{spaces}\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-booking-made-approval-mail":"enable","booking-made-approval-mail-title":"You have made a new booking. Please wait for approval before processing payment","booking-made-approval-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\nAt this point, please do nothing yet. \nAfter admin approve your booking, you will get email notification and then you can process payment later.","enable-booking-approve-mail":"enable","booking-approve-mail-title":"Your booking has been approved to process the payment","booking-approve-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\nAdmin has now approved your booking so you can process the payment. \nPlease note that this is not the final approve until you finish the payment.","enable-customer-invoice":"enable","enable-deposit-payment-made-mail":"enable","deposit-payment-made-mail-title":"Your deposit has been successfully processed","deposit-payment-made-mail":"<strong>Dear {customer-name}<\/strong>,\nCongratulations! Your deposit has been sucessfully processed.\n\n{tour-name}\n{order-number}\n{travel-date}\n{submission-amount}\n\nCustomer\'s Note: {customer-note}\n\n{payment-method}\n{submission-date}\n{transaction-id}\n{spaces}\n\nYou can view <a href=\"{invoice-link}\">the receipt here<\/a>","enable-receipt-submission-mail":"enable","receipt-submission-mail-title":"Thank you for payment submission.","receipt-submission-mail":"<strong>Dear {customer-name}<\/strong>,\nThank you for payment submission. After reveiwing, we will get back to you soon. \n\n{tour-name}\n{order-number}\n\n{submission-date}\n{payment-method}\n{submission-amount}\n{transaction-id}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-receipt-approve-mail":"enable","receipt-approve-mail-title":"Your payment submission has been approved.","receipt-approve-mail":"<strong>Dear {customer-name}<\/strong>,\nYour payment submission has been approved. You can make another deposit or the final payment from your dashboard.\n\n{tour-name}\n{order-number}\n\n{submission-date}\n{payment-method}\n{submission-amount}\n{transaction-id}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-receipt-reject-mail":"enable","receipt-reject-mail-title":"Your payment submission has been rejected.","receipt-reject-mail":"<strong>Dear {customer-name}<\/strong>,\nUnfortunately, your payment submission is not valid. Please review your payment receipt and submit again. \n\n{tour-name}\n{order-number}\n\n{submission-date}\n{payment-method}\n{submission-amount}\n{transaction-id}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enquiry-form-fields":"","single-related-tour-grid-style":"style-1","tour-search-item-frame-shadow-size":"25px","tour-search-item-frame-shadow-color":"#0a0a0a","tour-search-item-frame-shadow-opacity":"0.08","enable-cancel-booking-mail":"enable","archive-description":"disable","search-page-tour-grid-style":"style-2","search-page-tour-frame-shadow-size":"25px","search-page-tour-frame-shadow-color":"#0a0a0a","search-page-tour-frame-shadow-opacity":"0.08","enable-guest-booking":"enable","tour-search-filter-state":"enable","header-price-decimal-digit":"0","apply-coupon-after-tax":"disable","single-tour-extra-booking-info":""},"tourmaster_payment":{"stripe-secret-key":"","stripe-publishable-key":"","stripe-currency-code":"usd","paypal-live-mode":"disable","paypal-business-email":"sandbox1@goodlayers.com","paypal-currency-code":"USD","payment-method":["booking","paypal","credit-card"],"accepted-credit-card-type":["visa","master-card","american-express","jcb"],"term-of-service-page":"","privacy-statement-page":"","credit-card-payment-gateway":"stripe","paymill-private-key":"","paymill-public-key":"","paymill-currency-code":"usd","authorize-live-mode":"disable","authorize-api-id":"","authorize-transaction-key":"","enable-deposit-payment":"enable","deposit-payment-amount":"30","display-deposit-payment-day":"","paypal-service-fee":"3","enable-payment":"enable","payment-admin-approval":"disable","enable-full-payment":"enable","deposit2-payment-amount":"25","deposit3-payment-amount":"20","deposit4-payment-amount":"0","deposit5-payment-amount":"0","credit-card-service-fee":"","hipayprofessional-live-mode":"disable","hipayprofessional-merchant-login":"","hipayprofessional-merchant-password":"","hipayprofessional-website":"","hipayprofessional-website-category":"","hipayprofessional-website-shopid":"","hipayprofessional-website-logo":"","hipayprofessional-email-notification":"","hipayprofessional-website-rating":"ALL","hipayprofessional-currency-code":"EUR","hipayprofessional-min-amount":"2","hipayprofessional-max-amount":"2500"},"tourmaster_color":{"tourmaster-theme-color":"#aa9875","tourmaster-rating-color":"#aa9875","user-template-background":"#f3f3f3","user-template-navigation-background":"#ffffff","user-template-navigation-title":"#3f3f3f","user-template-navigation-text":"#7d7d7d","user-template-navigation-border":"#e5e5e5","user-template-breadcrumbs-text":"#a5a5a5","user-template-content-block-background":"#ffffff","user-template-content-block-title-link":"#9e9e9e","user-template-content-block-border":"#e8e8e8","user-template-content-block-text":"#545454","tourmaster-input-box-text":"#545454","tourmaster-input-box-background":"#ffffff","tourmaster-input-box-border":"#e5e5e5","tourmaster-upload-box-background":"#f3f3f3","tourmaster-upload-box-text":"#a6a6a6","tourmaster-theme-color-link":"#aa9875","tourmaster-theme-color-light":"#aa9875","tourmaster-single-price-head-background":"#aa9875","tourmaster-single-price-head-featured-background":"#aa9875","tourmaster-single-price-head-discount-text":"#a3a3a3","tourmaster-remove-color":"#ba4a4a","user-login-submenu-background":"#ffffff","user-login-submenu-border":"#e6e6e6","user-login-submenu-text":"#878787","user-template-my-booking-price-text":"#424242","user-template-my-booking-filter-text":"#a5a5a5","tourmaster-booking-status-text-color":"#acacac","tourmaster-booking-status-pending-color":"#24a04a","tourmaster-booking-status-online-paid":"#cd9b45","tourmaster-booking-receipt-button-background":"#48a198","tourmaster-invoice-title-color":"#121212","tourmaster-invoice-price-head-background":"#f3f3f3","tourmaster-invoice-price-head-text":"#454545","tourmaster-invoice-price-text":"#7b7b7b","tourmaster-invoice-price-amount":"#1e1e1e","tourmaster-input-form-label":"#5c5c5c","tourmaster-datepicker-background":"#f5f5f5","tourmaster-datepicker-border":"#ebebeb","tourmaster-datepicker-head":"#808080","tourmaster-datepicker-enable-background":"#ffffff","tourmaster-datepicker-enable-text":"#5b5b5b","tourmaster-datepicker-disable-text":"#c0c0c0","tourmaster-booking-bar-background":"#ffffff","tourmaster-booking-bar-text":"#333333","tourmaster-booking-bar-wishlist-background":"#fbfbfb","tourmaster-booking-bar-wishlist-border":"#ebebeb","tourmaster-booking-bar-summary-title":"#000000","tourmaster-booking-bar-summary-text":"#414141","tourmaster-price-breakdown-color":"#515151","tourmaster-price-breakdown-total-color":"#242424","single-tour-info-background":"#f5f5f5","single-tour-info-text":"#414141","tourmaster-review-title-color":"#272727","tourmaster-review-date-color":"#a3a3a3","tourmaster-payment-complete-background":"#f5f5f5","tourmaster-payment-complete-title":"#262626","tourmaster-payment-complete-border":"#e3e3e3","tourmaster-pagination-background":"#696969","tourmaster-pagination-text":"#f3f3f3","tourmaster-payment-step-icon-background":"#161616","tour-item-frame-background":"#ffffff","tour-price":"#aa9875","tour-discount-price":"#a7a7a7","tourmaster-lightbox-background":"#ffffff","tourmaster-lightbox-title":"#0e0e0e","tourmaster-lightbox-form-label":"#5c5c5c","tourmaster-content-navigation-background":"#ffffff","tourmaster-content-navigation-text":"#9a9a9a","tourmaster-content-navigation-active-text":"#1b1b1b","tourmaster-search-frame-background":"#ffffff","tourmaster-single-price-head-background-right":"#aa9875","tour-item-title-color":"#333333","tour-grid-bottom-price-background":"#e7e7e7","tour-grid-bottom-price-head":"#5c5c5c","tour-grid-bottom-discount-price":"#989898","tourmaster-input-box-background-validate-error":"#fff9f9","search-page-background":"#ffffff","tourmaster-search-input-background":"#ffffff","tourmaster-search-input-border":"#e5e5e5","tourmaster-search-input-text":"#7f7f7f","tourmaster-search-input-icon":"#383838","tourmaster-tour-review-title":"#313131","tourmaster-tour-review-user-name":"#5f5f5f","tourmaster-search-input-title":"#ffffff","tourmaster-search-input-label":"#383838","tourmaster-booking-status-deposit-paid":"#5b9dd9","tourmaster-price-breakdown-total-color-deposit":"#a1a1a1","payment-service-form-background":"#f5f5f5","payment-service-form-title":"#1a1a1a","payment-service-form-title-border":"#e3e3e3","payment-service-form-label":"#6a6a6a","search-not-found-background":"#f6f6f6","search-not-found-title":"#cccccc","search-not-found-caption":"#a8a8a8","booking-bar-tab-title-background":"#f5f5f5","booking-bar-tab-title-text":"#929292","booking-bar-tab-active-title-text":"#242424","enquery-success-message-background":"#f1f8ff","enquery-success-message-border":"#e1ebfe","enquery-success-message-text":"#758ea8","enquery-failed-message-background":"#fff1f1","enquery-failed-message-border":"#fee1e1","enquery-failed-message-text":"#ffffff","urgency-message-background":"#343434","urgency-message-text":"#a87575","tour-item-order-filterer-background":"#ffffff","tour-item-order-filterer-combobox-background":"#ffffff","tour-item-order-filterer-icon":"#adadad","tourmaster-search-filter-text":"#878787","tourmaster-single-price-head-text":"#1a1a1a","tourmaster-booking-status-wait-for-approval":"#e0724e","tourmaster-payment-title-overlay":"#000000","single-tour-top-gradient":"#000","single-tour-top-gradient-max-opacity":"1","single-tour-bottom-gradient-max-opacity":"0.6","booking-bar-tab-title-divider":"#aa9875","tourmaster-checkbox-box-border":"#cccccc","tourmaster-search-item-title":"#aa9875","tourmaster-search-item-icon":"#212121","tour-item-title-hover-color":"#333333","tourmaster-payment-title-Color":"#ffffff","tourmaster-payment-title-overlay-opacity":"0.5","tourmaster-payment-step-title-Color":"#ffffff"},"tourmaster_plugin":{"font-awesome":"enable","elegant-icon":"enable"}}';
			}else if( $slug == 'winery' ){
				$data = '{"tourmaster_general":{"container-width":"1260px","container-padding":"20px","item-padding":"20px","datepicker-date-format":"d M yy","money-format":"$NUMBER","tax-rate":"9","login-page":"4852","register-page":"4854","user-page":"4833","user-navigation-bottom-text":"<h5>Need Help?<\/5>\n[gdlr_core_space height=\"1px\"]\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"18px\" color=\"#444\" margin-right=\"10px\" ] <span style=\"font-size: 15px; font-weight: 400;\"> 1.828.456.345\n<a href=\"#\">Help@traveltourwp.com<\/a>","payment-page":"","payment-complete-bottom-text":"","search-page":"4858","search-page-num-fetch":"6","search-page-tour-style":"grid-with-frame","search-page-with-frame":"enable","search-page-column-size":"20","search-page-thumbnail-size":"Personnel Thumbnail","search-page-tour-info":["duration-text"],"search-page-excerpt":"none","search-page-excerpt-number":"14","search-page-tour-rating":"enable","invoice-logo":"4890","invoice-logo-width":"250px","invoice-company-name":"GoodLayers Travel Tour","invoice-company-info":"11 Main Street, Kingston, London 22EPH","text":"","textarea":"","combobox":"1","multi-combobox":"","radioimage":"1","checkbox":"disable","tour-header-top-padding":"500px","tour-header-bottom-padding":"45px","single-tour-default-sidebar":"single-tour","payment-page-sidebar":"payment","archive-page":"","search-sidebar":"none","search-sidebar-left":"none","search-sidebar-right":"single-tour","system-email-address":"main@goodlayers.com","admin-email-address":"contact@goodlayers.com","mail-header-logo":"","mail-footer-left":"<span style=\"font-weight: bold\" >Need help?<\/span>\n<a href=\"mailto:help@traveltourwptheme.com\">help@traveltourwptheme.com<\/a>\n1.828.344.234","mail-footer-right":"<span><\/span>\nLogin to <a href=\"http:\/\/demo.goodlayers.com\/traveltour\/login\">your account<\/a>\nCopyright \u00a9 2017, GoodLayers","enable-admin-booking-made-mail":"enable","admin-booking-made-mail-title":"A new booking has been made","admin-booking-made-mail":"<strong>Dear Admin,<\/strong>\nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-admin-payment-submitted-mail":"enable","admin-payment-submitted-mail-title":"A new payment receipt has been submitted","admin-payment-submitted-mail":"<strong>Dear Admin,<\/strong>\nA new payment receipt has been submitted\n\n{tour-name}\n{order-number}\n{travel-date}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-admin-online-payment-made-mail":"enable","admin-online-payment-made-mail-title":"A new booking has been made and successfully paid","admin-online-payment-made-mail":"<strong>Dear Admin,<\/strong>\nA new booking has been made and sucessfully paid.\n\n{payment-method}\n{payment-date}\n{transaction-id}\n{spaces}\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-registration-complete-mail":"enable","registration-complete-mail-title":"Congratulations! Your account has been created","registration-complete-mail":"{header}Congratulations {customer-name}!{\/header}\n\nYour account has been successfully created. Now you can explore new tours and mange booking via the dashboard. You can also review tours and make a wishlist from the dashboard as well.\n\n<a href=\"{profile-page-link}\" >Click here to login to travel tour<\/a>","enable-booking-made-mail":"enable","booking-made-mail-title":"You have made a new booking","booking-made-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-payment-made-mail":"enable","payment-made-mail-title":"Your payment has been successfully processed","payment-made-mail":"<strong>Dear {customer-name}<\/strong>,\nCongratulations! Your payment has been sucessfully processed.\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\nYou can view <a href=\"{invoice-link}\">the receipt here<\/a>","enable-booking-cancelled-mail":"enable","booking-cancelled-mail-title":"Your booking has been cancelled","booking-cancelled-mail":"<strong>Dear {customer-name}<\/strong>,\nWe are here to inform that your booking has been cancelled.\n\n{tour-name}\n{order-number}\n{travel-date}","enable-booking-reject-mail":"enable","booking-reject-mail-title":"Your booking has been rejected","booking-reject-mail":"<strong>Dear {customer-name}<\/strong>,\nWe are sorry to inform that your booking has been rejected. Your booking was rejected because of your payment was not successfully processed or your booking might be in the pending status for too long.\n\n{tour-name}\n{order-number}\n{travel-date}","enable-booking-via-email":"enable","enable-admin-guest-booking-made-mail":"enable","admin-guest-booking-made-mail-title":"A new booking has been made (Guest booked via email)","admin-guest-booking-made-mail":"<strong>Dear Admin,<\/strong> \nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>\n{spaces}\n\nCustomer\u2019s email : {customer-email}\nPlease contact to your customer back for further details.","enable-guest-booking-made-mail":"enable","guest-booking-made-mail-title":"You have made a new booking via email","guest-booking-made-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n{divider}\nOur team will contact you back via the email you provided,\n{customer-email}","price-breakdown-decimal-digit":"2","register-term-of-service-page":"","register-privacy-statement-page":"","user-default-country":"Italy","cancel-booking-day":"","tour-staff-capability":["edit_tour","read_tour","delete_tour","edit_tours","edit_others_tours","publish_tours","read_private_tours","manage_tour_category","manage_tour_tag","manage_tour_filter","edit_coupon","read_coupon","delete_coupon","edit_coupons","edit_others_coupons","publish_coupons","read_private_coupons","manage_tour_order","edit_service","read_service","delete_service","edit_services","edit_others_services","publish_services","read_private_services"],"tour-author-capability":["edit_tour","read_tour","delete_tour","edit_tours","edit_others_tours","publish_tours","read_private_tours","manage_tour_category","manage_tour_tag","manage_tour_filter","edit_coupon","read_coupon","delete_coupon","edit_coupons","edit_others_coupons","publish_coupons","read_private_coupons"],"tour-search-item-style":"medium-with-frame","tour-search-item-thumbnail":"Tour Category","tour-search-item-info":["duration-text","availability"],"tour-search-item-excerpt":"specify-number","tour-search-item-excerpt-number":"14","tour-search-item-rating":"enable","tour-search-order-filterer-grid-style":"grid-with-frame","tour-search-order-filterer-grid-style-thumbnail":"Blog Column Thumbnail","tour-search-order-filterer-grid-style-column":"30","enable-tour-search-filter":"enable","tour-search-fields":["keywords","tour_tag","duration","date","month","min-price","max-price"],"tour-search-rating-field":"enable","tour-search-filters":["tour-activity","tour-destination"],"search-not-found-fields":"","search-not-found-style":"column","show-remaining-available-number":"enable","max-dropdown-people-amount":"5","enable-single-sidebar-widget-on-mobile":"enable","enable-single-related-tour":"enable","single-related-tour-style":"grid","single-related-tour-column-size":"30","single-related-tour-num-fetch":"2","single-related-tour-thumbnail-size":"Blog Column Thumbnail","single-related-tour-price-position":"right-title","single-related-tour-info":"","single-related-tour-excerpt":"none","single-related-tour-excerpt-number":"20","single-related-tour-rating":"enable","system-email-name":"WORDPRESS","admin-enquiry-mail-title":"You received a new enquiry","admin-enquiry-mail-content":"Dear Admin,\n\nYou received a new enquiry from {tour-name}\n\nFrom: {full-name}\n\nEmail: {email-address} \n\nMessage: {your-enquiry}\n\n","enquiry-mail-title":"You have submitted an enquiry","enquiry-mail-content":"Dear {full-name},\n\nYou have sumiited an enquiry from {tour-name}\n\nMessage: {your-enquiry}\n\nOur team will contact you back via the email you provided, {email-address} \n\nThank you!","tour-search-item-num-fetch":"9","enable-tour-schema":"enable","tour-schema-price-currency":"","tour-header-overlay-opacity":"15","max-dropdown-room-amount":"10","price-thousand-separator":",","price-decimal-separator":".","included-tax-in-price":"disable","enable-recaptcha":"disable","enable-membership":"enable","mobile-login-link":"disable","block-seat-status":"book","contact-detail-fields":"","additional-traveller-fields":"","search-page-style":"style-2","search-month-amount":"12","tour-search-default-style":"grid","tour-search-order-filterer-grid-style-type":"style-2","invoice-customer-address":"","single-tour-style":"style-2","mobile-content-read-more":"enable","mobile-booking-bar-position":"bottom","single-tour-header-gradient":"bottom","single-tour-top-gradient-size":"154px","single-tour-bottom-gradient-size":"291px","update-header-price":"enable","require-adult-to-book-tour":"enable","admin-registration-email-address":"contact@goodlayers.com","enable-admin-registration-complete-mail":"enable","admin-registration-complete-mail-title":"New user registration","admin-registration-complete-mail":"<strong>Dear Admin,<\/strong> \n New customer has created an account \n\n Customer\u2019s name : {customer-name} \n Customer\u2019s email : {customer-email} \n Customer\u2019s contact number : {customer-phone}","enable-admin-booking-made-approval-mail":"enable","admin-booking-made-approval-mail-title":"A new booking has been made. Please approve the booking so customer can pay.","admin-booking-made-approval-mail":"<strong>Dear Admin,<\/strong>\nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>\n\nPlease note that this customer can\'t process the payment untill you approvde thier booking.","enable-admin-deposit-payment-made-mail":"enable","admin-deposit-payment-made-mail-title":"New deposit has been successfully paid","admin-deposit-payment-made-mail":"<strong>Dear Admin,<\/strong>\nNew deposit has been successfully paid.\n\n{payment-method}\n{submission-date}\n{transaction-id}\n{submission-amount}\n{spaces}\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-booking-made-approval-mail":"enable","booking-made-approval-mail-title":"You have made a new booking. Please wait for approval before processing payment","booking-made-approval-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\nAt this point, please do nothing yet. \nAfter admin approve your booking, you will get email notification and then you can process payment later.","enable-booking-approve-mail":"enable","booking-approve-mail-title":"Your booking has been approved to process the payment","booking-approve-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\nAdmin has now approved your booking so you can process the payment. \nPlease note that this is not the final approve until you finish the payment.","enable-customer-invoice":"enable","enable-deposit-payment-made-mail":"enable","deposit-payment-made-mail-title":"Your deposit has been successfully processed","deposit-payment-made-mail":"<strong>Dear {customer-name}<\/strong>,\nCongratulations! Your deposit has been sucessfully processed.\n\n{tour-name}\n{order-number}\n{travel-date}\n{submission-amount}\n\nCustomer\'s Note: {customer-note}\n\n{payment-method}\n{submission-date}\n{transaction-id}\n{spaces}\n\nYou can view <a href=\"{invoice-link}\">the receipt here<\/a>","enable-receipt-submission-mail":"enable","receipt-submission-mail-title":"Thank you for payment submission.","receipt-submission-mail":"<strong>Dear {customer-name}<\/strong>,\nThank you for payment submission. After reveiwing, we will get back to you soon. \n\n{tour-name}\n{order-number}\n\n{submission-date}\n{payment-method}\n{submission-amount}\n{transaction-id}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-receipt-approve-mail":"enable","receipt-approve-mail-title":"Your payment submission has been approved.","receipt-approve-mail":"<strong>Dear {customer-name}<\/strong>,\nYour payment submission has been approved. You can make another deposit or the final payment from your dashboard.\n\n{tour-name}\n{order-number}\n\n{submission-date}\n{payment-method}\n{submission-amount}\n{transaction-id}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-receipt-reject-mail":"enable","receipt-reject-mail-title":"Your payment submission has been rejected.","receipt-reject-mail":"<strong>Dear {customer-name}<\/strong>,\nUnfortunately, your payment submission is not valid. Please review your payment receipt and submit again. \n\n{tour-name}\n{order-number}\n\n{submission-date}\n{payment-method}\n{submission-amount}\n{transaction-id}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enquiry-form-fields":"","single-related-tour-grid-style":"style-1","tour-search-item-frame-shadow-size":"25px","tour-search-item-frame-shadow-color":"#0a0a0a","tour-search-item-frame-shadow-opacity":"0.08","enable-cancel-booking-mail":"enable","archive-description":"disable","search-page-tour-grid-style":"style-2","search-page-tour-frame-shadow-size":"25px","search-page-tour-frame-shadow-color":"#0a0a0a","search-page-tour-frame-shadow-opacity":"0.08","enable-guest-booking":"enable","tour-search-filter-state":"enable","header-price-decimal-digit":"0","apply-coupon-after-tax":"disable","single-tour-extra-booking-info":""},"tourmaster_payment":{"stripe-secret-key":"","stripe-publishable-key":"","stripe-currency-code":"usd","paypal-live-mode":"disable","paypal-business-email":"sandbox1@goodlayers.com","paypal-currency-code":"USD","payment-method":["booking","paypal","credit-card"],"accepted-credit-card-type":["visa","master-card","american-express","jcb"],"term-of-service-page":"","privacy-statement-page":"","credit-card-payment-gateway":"stripe","paymill-private-key":"","paymill-public-key":"","paymill-currency-code":"usd","authorize-live-mode":"disable","authorize-api-id":"","authorize-transaction-key":"","enable-deposit-payment":"enable","deposit-payment-amount":"30","display-deposit-payment-day":"","paypal-service-fee":"3","enable-payment":"enable","payment-admin-approval":"disable","enable-full-payment":"enable","deposit2-payment-amount":"25","deposit3-payment-amount":"20","deposit4-payment-amount":"0","deposit5-payment-amount":"0","credit-card-service-fee":"","hipayprofessional-live-mode":"disable","hipayprofessional-merchant-login":"","hipayprofessional-merchant-password":"","hipayprofessional-website":"","hipayprofessional-website-category":"","hipayprofessional-website-shopid":"","hipayprofessional-website-logo":"","hipayprofessional-email-notification":"","hipayprofessional-website-rating":"ALL","hipayprofessional-currency-code":"EUR","hipayprofessional-min-amount":"2","hipayprofessional-max-amount":"2500"},"tourmaster_color":{"tourmaster-theme-color":"#982d30","tourmaster-rating-color":"#ffa11a","user-template-background":"#f3f3f3","user-template-navigation-background":"#ffffff","user-template-navigation-title":"#3f3f3f","user-template-navigation-text":"#7d7d7d","user-template-navigation-border":"#e5e5e5","user-template-breadcrumbs-text":"#a5a5a5","user-template-content-block-background":"#ffffff","user-template-content-block-title-link":"#9e9e9e","user-template-content-block-border":"#e8e8e8","user-template-content-block-text":"#545454","tourmaster-input-box-text":"#545454","tourmaster-input-box-background":"#ffffff","tourmaster-input-box-border":"#e5e5e5","tourmaster-upload-box-background":"#f3f3f3","tourmaster-upload-box-text":"#a6a6a6","tourmaster-theme-color-link":"#982d30","tourmaster-theme-color-light":"#982d30","tourmaster-single-price-head-background":"#982d30","tourmaster-single-price-head-featured-background":"#982d30","tourmaster-single-price-head-discount-text":"#a3a3a3","tourmaster-remove-color":"#ba4a4a","user-login-submenu-background":"#ffffff","user-login-submenu-border":"#e6e6e6","user-login-submenu-text":"#878787","user-template-my-booking-price-text":"#424242","user-template-my-booking-filter-text":"#a5a5a5","tourmaster-booking-status-text-color":"#acacac","tourmaster-booking-status-pending-color":"#24a04a","tourmaster-booking-status-online-paid":"#cd9b45","tourmaster-booking-receipt-button-background":"#48a198","tourmaster-invoice-title-color":"#121212","tourmaster-invoice-price-head-background":"#f3f3f3","tourmaster-invoice-price-head-text":"#454545","tourmaster-invoice-price-text":"#7b7b7b","tourmaster-invoice-price-amount":"#1e1e1e","tourmaster-input-form-label":"#5c5c5c","tourmaster-datepicker-background":"#f5f5f5","tourmaster-datepicker-border":"#ebebeb","tourmaster-datepicker-head":"#808080","tourmaster-datepicker-enable-background":"#ffffff","tourmaster-datepicker-enable-text":"#5b5b5b","tourmaster-datepicker-disable-text":"#c0c0c0","tourmaster-booking-bar-background":"#ffffff","tourmaster-booking-bar-text":"#333333","tourmaster-booking-bar-wishlist-background":"#fbfbfb","tourmaster-booking-bar-wishlist-border":"#ebebeb","tourmaster-booking-bar-summary-title":"#000000","tourmaster-booking-bar-summary-text":"#414141","tourmaster-price-breakdown-color":"#515151","tourmaster-price-breakdown-total-color":"#242424","single-tour-info-background":"#f5f5f5","single-tour-info-text":"#414141","tourmaster-review-title-color":"#272727","tourmaster-review-date-color":"#a3a3a3","tourmaster-payment-complete-background":"#f5f5f5","tourmaster-payment-complete-title":"#262626","tourmaster-payment-complete-border":"#e3e3e3","tourmaster-pagination-background":"#696969","tourmaster-pagination-text":"#f3f3f3","tourmaster-payment-step-icon-background":"#161616","tour-item-frame-background":"#ffffff","tour-price":"#982d30","tour-discount-price":"#a7a7a7","tourmaster-lightbox-background":"#ffffff","tourmaster-lightbox-title":"#0e0e0e","tourmaster-lightbox-form-label":"#5c5c5c","tourmaster-content-navigation-background":"#ffffff","tourmaster-content-navigation-text":"#9a9a9a","tourmaster-content-navigation-active-text":"#1b1b1b","tourmaster-search-frame-background":"#ffffff","tourmaster-single-price-head-background-right":"#982d30","tour-item-title-color":"#333333","tour-grid-bottom-price-background":"#e7e7e7","tour-grid-bottom-price-head":"#5c5c5c","tour-grid-bottom-discount-price":"#989898","tourmaster-input-box-background-validate-error":"#fff9f9","search-page-background":"#ffffff","tourmaster-search-input-background":"#ffffff","tourmaster-search-input-border":"#e5e5e5","tourmaster-search-input-text":"#7f7f7f","tourmaster-search-input-icon":"#383838","tourmaster-tour-review-title":"#313131","tourmaster-tour-review-user-name":"#5f5f5f","tourmaster-search-input-title":"#ffffff","tourmaster-search-input-label":"#383838","tourmaster-booking-status-deposit-paid":"#5b9dd9","tourmaster-price-breakdown-total-color-deposit":"#a1a1a1","payment-service-form-background":"#f5f5f5","payment-service-form-title":"#1a1a1a","payment-service-form-title-border":"#e3e3e3","payment-service-form-label":"#6a6a6a","search-not-found-background":"#f6f6f6","search-not-found-title":"#cccccc","search-not-found-caption":"#a8a8a8","booking-bar-tab-title-background":"#f5f5f5","booking-bar-tab-title-text":"#929292","booking-bar-tab-active-title-text":"#242424","enquery-success-message-background":"#f1f8ff","enquery-success-message-border":"#e1ebfe","enquery-success-message-text":"#758ea8","enquery-failed-message-background":"#fff1f1","enquery-failed-message-border":"#fee1e1","enquery-failed-message-text":"#ffffff","urgency-message-background":"#343434","urgency-message-text":"#a87575","tour-item-order-filterer-background":"#ffffff","tour-item-order-filterer-combobox-background":"#ffffff","tour-item-order-filterer-icon":"#adadad","tourmaster-search-filter-text":"#878787","tourmaster-single-price-head-text":"#1a1a1a","tourmaster-booking-status-wait-for-approval":"#e0724e","tourmaster-payment-title-overlay":"#000000","single-tour-top-gradient":"#000","single-tour-top-gradient-max-opacity":"1","single-tour-bottom-gradient-max-opacity":"0.6","booking-bar-tab-title-divider":"#982d30","tourmaster-checkbox-box-border":"#cccccc","tourmaster-search-item-title":"#982d30","tourmaster-search-item-icon":"#212121","tour-item-title-hover-color":"#333333","tourmaster-payment-title-Color":"#ffffff","tourmaster-payment-title-overlay-opacity":"0.5","tourmaster-payment-step-title-Color":"#ffffff"},"tourmaster_plugin":{"font-awesome":"enable","elegant-icon":"enable"}}';
			}else if( $slug == 'museum' ){
				$data = '{"tourmaster_general":{"container-width":"1260px","container-padding":"20px","item-padding":"20px","datepicker-date-format":"d M yy","money-format":"$NUMBER","tax-rate":"9","login-page":"4852","register-page":"4854","user-page":"4833","user-navigation-bottom-text":"<h5>Need Help?<\/5>\n[gdlr_core_space height=\"1px\"]\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"18px\" color=\"#444\" margin-right=\"10px\" ] <span style=\"font-size: 15px; font-weight: 400;\"> 1.828.456.345\n<a href=\"#\">Help@traveltourwp.com<\/a>","payment-page":"","payment-complete-bottom-text":"","search-page":"4858","search-page-num-fetch":"6","search-page-tour-style":"grid-with-frame","search-page-with-frame":"enable","search-page-column-size":"20","search-page-thumbnail-size":"Personnel Thumbnail","search-page-tour-info":["duration-text"],"search-page-excerpt":"none","search-page-excerpt-number":"14","search-page-tour-rating":"enable","invoice-logo":"4890","invoice-logo-width":"250px","invoice-company-name":"GoodLayers Travel Tour","invoice-company-info":"11 Main Street, Kingston, London 22EPH","text":"","textarea":"","combobox":"1","multi-combobox":"","radioimage":"1","checkbox":"disable","tour-header-top-padding":"605px","tour-header-bottom-padding":"45px","single-tour-default-sidebar":"single-tour","payment-page-sidebar":"payment","archive-page":"","search-sidebar":"none","search-sidebar-left":"none","search-sidebar-right":"single-tour","system-email-address":"main@goodlayers.com","admin-email-address":"contact@goodlayers.com","mail-header-logo":"","mail-footer-left":"<span style=\"font-weight: bold\" >Need help?<\/span>\n<a href=\"mailto:help@traveltourwptheme.com\">help@traveltourwptheme.com<\/a>\n1.828.344.234","mail-footer-right":"<span><\/span>\nLogin to <a href=\"http:\/\/demo.goodlayers.com\/traveltour\/login\">your account<\/a>\nCopyright \u00a9 2017, GoodLayers","enable-admin-booking-made-mail":"enable","admin-booking-made-mail-title":"A new booking has been made","admin-booking-made-mail":"<strong>Dear Admin,<\/strong>\nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-admin-payment-submitted-mail":"enable","admin-payment-submitted-mail-title":"A new payment receipt has been submitted","admin-payment-submitted-mail":"<strong>Dear Admin,<\/strong>\nA new payment receipt has been submitted\n\n{tour-name}\n{order-number}\n{travel-date}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-admin-online-payment-made-mail":"enable","admin-online-payment-made-mail-title":"A new booking has been made and successfully paid","admin-online-payment-made-mail":"<strong>Dear Admin,<\/strong>\nA new booking has been made and sucessfully paid.\n\n{payment-method}\n{payment-date}\n{transaction-id}\n{spaces}\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-registration-complete-mail":"enable","registration-complete-mail-title":"Congratulations! Your account has been created","registration-complete-mail":"{header}Congratulations {customer-name}!{\/header}\n\nYour account has been successfully created. Now you can explore new tours and mange booking via the dashboard. You can also review tours and make a wishlist from the dashboard as well.\n\n<a href=\"{profile-page-link}\" >Click here to login to travel tour<\/a>","enable-booking-made-mail":"enable","booking-made-mail-title":"You have made a new booking","booking-made-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-payment-made-mail":"enable","payment-made-mail-title":"Your payment has been successfully processed","payment-made-mail":"<strong>Dear {customer-name}<\/strong>,\nCongratulations! Your payment has been sucessfully processed.\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\nYou can view <a href=\"{invoice-link}\">the receipt here<\/a>","enable-booking-cancelled-mail":"enable","booking-cancelled-mail-title":"Your booking has been cancelled","booking-cancelled-mail":"<strong>Dear {customer-name}<\/strong>,\nWe are here to inform that your booking has been cancelled.\n\n{tour-name}\n{order-number}\n{travel-date}","enable-booking-reject-mail":"enable","booking-reject-mail-title":"Your booking has been rejected","booking-reject-mail":"<strong>Dear {customer-name}<\/strong>,\nWe are sorry to inform that your booking has been rejected. Your booking was rejected because of your payment was not successfully processed or your booking might be in the pending status for too long.\n\n{tour-name}\n{order-number}\n{travel-date}","enable-booking-via-email":"enable","enable-admin-guest-booking-made-mail":"enable","admin-guest-booking-made-mail-title":"A new booking has been made (Guest booked via email)","admin-guest-booking-made-mail":"<strong>Dear Admin,<\/strong> \nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>\n{spaces}\n\nCustomer\u2019s email : {customer-email}\nPlease contact to your customer back for further details.","enable-guest-booking-made-mail":"enable","guest-booking-made-mail-title":"You have made a new booking via email","guest-booking-made-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n{divider}\nOur team will contact you back via the email you provided,\n{customer-email}","price-breakdown-decimal-digit":"2","register-term-of-service-page":"","register-privacy-statement-page":"","user-default-country":"Italy","cancel-booking-day":"","tour-staff-capability":["edit_tour","read_tour","delete_tour","edit_tours","edit_others_tours","publish_tours","read_private_tours","manage_tour_category","manage_tour_tag","manage_tour_filter","edit_coupon","read_coupon","delete_coupon","edit_coupons","edit_others_coupons","publish_coupons","read_private_coupons","manage_tour_order","edit_service","read_service","delete_service","edit_services","edit_others_services","publish_services","read_private_services"],"tour-author-capability":["edit_tour","read_tour","delete_tour","edit_tours","edit_others_tours","publish_tours","read_private_tours","manage_tour_category","manage_tour_tag","manage_tour_filter","edit_coupon","read_coupon","delete_coupon","edit_coupons","edit_others_coupons","publish_coupons","read_private_coupons"],"tour-search-item-style":"medium-with-frame","tour-search-item-thumbnail":"Tour Category","tour-search-item-info":["duration-text","availability"],"tour-search-item-excerpt":"none","tour-search-item-excerpt-number":"","tour-search-item-rating":"enable","tour-search-order-filterer-grid-style":"grid-with-frame","tour-search-order-filterer-grid-style-thumbnail":"Blog Column Thumbnail","tour-search-order-filterer-grid-style-column":"30","enable-tour-search-filter":"enable","tour-search-fields":["keywords","tour_tag","duration","date","month","min-price","max-price"],"tour-search-rating-field":"enable","tour-search-filters":["tour-activity","tour-destination"],"search-not-found-fields":"","search-not-found-style":"column","show-remaining-available-number":"enable","max-dropdown-people-amount":"5","enable-single-sidebar-widget-on-mobile":"enable","enable-single-related-tour":"enable","single-related-tour-style":"grid","single-related-tour-column-size":"30","single-related-tour-num-fetch":"2","single-related-tour-thumbnail-size":"Blog Column Thumbnail","single-related-tour-price-position":"right-title","single-related-tour-info":"","single-related-tour-excerpt":"none","single-related-tour-excerpt-number":"20","single-related-tour-rating":"enable","system-email-name":"WORDPRESS","admin-enquiry-mail-title":"You received a new enquiry","admin-enquiry-mail-content":"Dear Admin,\n\nYou received a new enquiry from {tour-name}\n\nFrom: {full-name}\n\nEmail: {email-address} \n\nMessage: {your-enquiry}\n\n","enquiry-mail-title":"You have submitted an enquiry","enquiry-mail-content":"Dear {full-name},\n\nYou have sumiited an enquiry from {tour-name}\n\nMessage: {your-enquiry}\n\nOur team will contact you back via the email you provided, {email-address} \n\nThank you!","tour-search-item-num-fetch":"9","enable-tour-schema":"enable","tour-schema-price-currency":"","tour-header-overlay-opacity":"15","max-dropdown-room-amount":"10","price-thousand-separator":",","price-decimal-separator":".","included-tax-in-price":"disable","enable-recaptcha":"disable","enable-membership":"enable","mobile-login-link":"disable","block-seat-status":"book","contact-detail-fields":"","additional-traveller-fields":"","search-page-style":"style-2","search-month-amount":"12","tour-search-default-style":"grid","tour-search-order-filterer-grid-style-type":"style-2","invoice-customer-address":"","single-tour-style":"style-2","mobile-content-read-more":"enable","mobile-booking-bar-position":"bottom","single-tour-header-gradient":"bottom","single-tour-top-gradient-size":"154px","single-tour-bottom-gradient-size":"291px","update-header-price":"enable","require-adult-to-book-tour":"enable","admin-registration-email-address":"contact@goodlayers.com","enable-admin-registration-complete-mail":"enable","admin-registration-complete-mail-title":"New user registration","admin-registration-complete-mail":"<strong>Dear Admin,<\/strong> \n New customer has created an account \n\n Customer\u2019s name : {customer-name} \n Customer\u2019s email : {customer-email} \n Customer\u2019s contact number : {customer-phone}","enable-admin-booking-made-approval-mail":"enable","admin-booking-made-approval-mail-title":"A new booking has been made. Please approve the booking so customer can pay.","admin-booking-made-approval-mail":"<strong>Dear Admin,<\/strong>\nA new booking form {customer-name} has been made.\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>\n\nPlease note that this customer can\'t process the payment untill you approvde thier booking.","enable-admin-deposit-payment-made-mail":"enable","admin-deposit-payment-made-mail-title":"New deposit has been successfully paid","admin-deposit-payment-made-mail":"<strong>Dear Admin,<\/strong>\nNew deposit has been successfully paid.\n\n{payment-method}\n{submission-date}\n{transaction-id}\n{submission-amount}\n{spaces}\n\n{tour-name}\n{order-number}\n{travel-date}\n\nCustomer\'s Note: {customer-note}\n{spaces}\n\nYou can view <a href=\"{admin-transaction-link}\">the transaction here<\/a>","enable-booking-made-approval-mail":"enable","booking-made-approval-mail-title":"You have made a new booking. Please wait for approval before processing payment","booking-made-approval-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\nAt this point, please do nothing yet. \nAfter admin approve your booking, you will get email notification and then you can process payment later.","enable-booking-approve-mail":"enable","booking-approve-mail-title":"Your booking has been approved to process the payment","booking-approve-mail":"<strong>Dear {customer-name}<\/strong>,\nYou have made a booking on\n\n{tour-name}\n{order-number}\n{travel-date}\n{total-price}\nCustomer\'s Note: {customer-note}\n\nAdmin has now approved your booking so you can process the payment. \nPlease note that this is not the final approve until you finish the payment.","enable-customer-invoice":"enable","enable-deposit-payment-made-mail":"enable","deposit-payment-made-mail-title":"Your deposit has been successfully processed","deposit-payment-made-mail":"<strong>Dear {customer-name}<\/strong>,\nCongratulations! Your deposit has been sucessfully processed.\n\n{tour-name}\n{order-number}\n{travel-date}\n{submission-amount}\n\nCustomer\'s Note: {customer-note}\n\n{payment-method}\n{submission-date}\n{transaction-id}\n{spaces}\n\nYou can view <a href=\"{invoice-link}\">the receipt here<\/a>","enable-receipt-submission-mail":"enable","receipt-submission-mail-title":"Thank you for payment submission.","receipt-submission-mail":"<strong>Dear {customer-name}<\/strong>,\nThank you for payment submission. After reveiwing, we will get back to you soon. \n\n{tour-name}\n{order-number}\n\n{submission-date}\n{payment-method}\n{submission-amount}\n{transaction-id}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-receipt-approve-mail":"enable","receipt-approve-mail-title":"Your payment submission has been approved.","receipt-approve-mail":"<strong>Dear {customer-name}<\/strong>,\nYour payment submission has been approved. You can make another deposit or the final payment from your dashboard.\n\n{tour-name}\n{order-number}\n\n{submission-date}\n{payment-method}\n{submission-amount}\n{transaction-id}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enable-receipt-reject-mail":"enable","receipt-reject-mail-title":"Your payment submission has been rejected.","receipt-reject-mail":"<strong>Dear {customer-name}<\/strong>,\nUnfortunately, your payment submission is not valid. Please review your payment receipt and submit again. \n\n{tour-name}\n{order-number}\n\n{submission-date}\n{payment-method}\n{submission-amount}\n{transaction-id}\n\n<a href=\"{payment-link}\" >Make a payment<\/a>\n<a href=\"{invoice-link}\" >View Invoice<\/a>\n{divider}\nIf you wish to do the bank transfer. Please use the information below.\n\n<strong>Bank name: Center London Bank<\/strong>\n<strong>Account Number: 4455-4445-333<\/strong>\n<strong>Swift Code: XXCCVV<\/strong>\n\nAfter transferring, please submit payment receipt from your dashboard. We\'ll get back to you when the submission verified.","enquiry-form-fields":"","single-related-tour-grid-style":"style-1","tour-search-item-frame-shadow-size":"25px","tour-search-item-frame-shadow-color":"#0a0a0a","tour-search-item-frame-shadow-opacity":"0.08","enable-cancel-booking-mail":"enable","archive-description":"disable","search-page-tour-grid-style":"style-2","search-page-tour-frame-shadow-size":"25px","search-page-tour-frame-shadow-color":"#0a0a0a","search-page-tour-frame-shadow-opacity":"0.08","enable-guest-booking":"enable","tour-search-filter-state":"enable","header-price-decimal-digit":"0","apply-coupon-after-tax":"disable","single-tour-extra-booking-info":""},"tourmaster_payment":{"stripe-secret-key":"","stripe-publishable-key":"","stripe-currency-code":"usd","paypal-live-mode":"disable","paypal-business-email":"sandbox1@goodlayers.com","paypal-currency-code":"USD","payment-method":["booking","paypal","credit-card"],"accepted-credit-card-type":["visa","master-card","american-express","jcb"],"term-of-service-page":"","privacy-statement-page":"","credit-card-payment-gateway":"stripe","paymill-private-key":"","paymill-public-key":"","paymill-currency-code":"usd","authorize-live-mode":"disable","authorize-api-id":"","authorize-transaction-key":"","enable-deposit-payment":"enable","deposit-payment-amount":"30","display-deposit-payment-day":"","paypal-service-fee":"3","enable-payment":"enable","payment-admin-approval":"disable","enable-full-payment":"enable","deposit2-payment-amount":"25","deposit3-payment-amount":"20","deposit4-payment-amount":"0","deposit5-payment-amount":"0","credit-card-service-fee":"","hipayprofessional-live-mode":"disable","hipayprofessional-merchant-login":"","hipayprofessional-merchant-password":"","hipayprofessional-website":"","hipayprofessional-website-category":"","hipayprofessional-website-shopid":"","hipayprofessional-website-logo":"","hipayprofessional-email-notification":"","hipayprofessional-website-rating":"ALL","hipayprofessional-currency-code":"EUR","hipayprofessional-min-amount":"2","hipayprofessional-max-amount":"2500"},"tourmaster_color":{"tourmaster-theme-color":"#aa9875","tourmaster-rating-color":"#aa9875","user-template-background":"#f3f3f3","user-template-navigation-background":"#ffffff","user-template-navigation-title":"#3f3f3f","user-template-navigation-text":"#7d7d7d","user-template-navigation-border":"#e5e5e5","user-template-breadcrumbs-text":"#a5a5a5","user-template-content-block-background":"#ffffff","user-template-content-block-title-link":"#9e9e9e","user-template-content-block-border":"#e8e8e8","user-template-content-block-text":"#545454","tourmaster-input-box-text":"#545454","tourmaster-input-box-background":"#ffffff","tourmaster-input-box-border":"#e5e5e5","tourmaster-upload-box-background":"#f3f3f3","tourmaster-upload-box-text":"#a6a6a6","tourmaster-theme-color-link":"#aa9875","tourmaster-theme-color-light":"#aa9875","tourmaster-single-price-head-background":"#aa9875","tourmaster-single-price-head-featured-background":"#aa9875","tourmaster-single-price-head-discount-text":"#a3a3a3","tourmaster-remove-color":"#ba4a4a","user-login-submenu-background":"#ffffff","user-login-submenu-border":"#e6e6e6","user-login-submenu-text":"#878787","user-template-my-booking-price-text":"#424242","user-template-my-booking-filter-text":"#a5a5a5","tourmaster-booking-status-text-color":"#acacac","tourmaster-booking-status-pending-color":"#24a04a","tourmaster-booking-status-online-paid":"#cd9b45","tourmaster-booking-receipt-button-background":"#48a198","tourmaster-invoice-title-color":"#121212","tourmaster-invoice-price-head-background":"#f3f3f3","tourmaster-invoice-price-head-text":"#454545","tourmaster-invoice-price-text":"#7b7b7b","tourmaster-invoice-price-amount":"#1e1e1e","tourmaster-input-form-label":"#5c5c5c","tourmaster-datepicker-background":"#f5f5f5","tourmaster-datepicker-border":"#ebebeb","tourmaster-datepicker-head":"#808080","tourmaster-datepicker-enable-background":"#ffffff","tourmaster-datepicker-enable-text":"#5b5b5b","tourmaster-datepicker-disable-text":"#c0c0c0","tourmaster-booking-bar-background":"#ffffff","tourmaster-booking-bar-text":"#333333","tourmaster-booking-bar-wishlist-background":"#fbfbfb","tourmaster-booking-bar-wishlist-border":"#ebebeb","tourmaster-booking-bar-summary-title":"#000000","tourmaster-booking-bar-summary-text":"#414141","tourmaster-price-breakdown-color":"#515151","tourmaster-price-breakdown-total-color":"#242424","single-tour-info-background":"#f5f5f5","single-tour-info-text":"#414141","tourmaster-review-title-color":"#272727","tourmaster-review-date-color":"#a3a3a3","tourmaster-payment-complete-background":"#f5f5f5","tourmaster-payment-complete-title":"#262626","tourmaster-payment-complete-border":"#e3e3e3","tourmaster-pagination-background":"#696969","tourmaster-pagination-text":"#f3f3f3","tourmaster-payment-step-icon-background":"#161616","tour-item-frame-background":"#ffffff","tour-price":"#aa9875","tour-discount-price":"#a7a7a7","tourmaster-lightbox-background":"#ffffff","tourmaster-lightbox-title":"#0e0e0e","tourmaster-lightbox-form-label":"#5c5c5c","tourmaster-content-navigation-background":"#ffffff","tourmaster-content-navigation-text":"#9a9a9a","tourmaster-content-navigation-active-text":"#1b1b1b","tourmaster-search-frame-background":"#ffffff","tourmaster-single-price-head-background-right":"#aa9875","tour-item-title-color":"#333333","tour-grid-bottom-price-background":"#e7e7e7","tour-grid-bottom-price-head":"#5c5c5c","tour-grid-bottom-discount-price":"#989898","tourmaster-input-box-background-validate-error":"#fff9f9","search-page-background":"#ffffff","tourmaster-search-input-background":"#ffffff","tourmaster-search-input-border":"#e5e5e5","tourmaster-search-input-text":"#7f7f7f","tourmaster-search-input-icon":"#383838","tourmaster-tour-review-title":"#313131","tourmaster-tour-review-user-name":"#5f5f5f","tourmaster-search-input-title":"#ffffff","tourmaster-search-input-label":"#383838","tourmaster-booking-status-deposit-paid":"#5b9dd9","tourmaster-price-breakdown-total-color-deposit":"#a1a1a1","payment-service-form-background":"#f5f5f5","payment-service-form-title":"#1a1a1a","payment-service-form-title-border":"#e3e3e3","payment-service-form-label":"#6a6a6a","search-not-found-background":"#f6f6f6","search-not-found-title":"#cccccc","search-not-found-caption":"#a8a8a8","booking-bar-tab-title-background":"#f5f5f5","booking-bar-tab-title-text":"#929292","booking-bar-tab-active-title-text":"#242424","enquery-success-message-background":"#f1f8ff","enquery-success-message-border":"#e1ebfe","enquery-success-message-text":"#758ea8","enquery-failed-message-background":"#fff1f1","enquery-failed-message-border":"#fee1e1","enquery-failed-message-text":"#ffffff","urgency-message-background":"#343434","urgency-message-text":"#a87575","tour-item-order-filterer-background":"#ffffff","tour-item-order-filterer-combobox-background":"#ffffff","tour-item-order-filterer-icon":"#adadad","tourmaster-search-filter-text":"#878787","tourmaster-single-price-head-text":"#1a1a1a","tourmaster-booking-status-wait-for-approval":"#e0724e","tourmaster-payment-title-overlay":"#000000","single-tour-top-gradient":"#000","single-tour-top-gradient-max-opacity":"1","single-tour-bottom-gradient-max-opacity":"0.6","booking-bar-tab-title-divider":"#aa9875","tourmaster-checkbox-box-border":"#cccccc","tourmaster-search-item-title":"#aa9875","tourmaster-search-item-icon":"#212121","tour-item-title-hover-color":"#333333","tourmaster-payment-title-Color":"#ffffff","tourmaster-payment-title-overlay-opacity":"0.5","tourmaster-payment-step-title-Color":"#ffffff"},"tourmaster_plugin":{"font-awesome":"enable","elegant-icon":"enable"}}';
			} 

			if( !empty($data) ){
				$import_options = json_decode($data, true);
				if( !empty($import_options) && is_array($import_options) ){
					foreach( $import_options as $option_slug => $option ){
						update_option($option_slug, $option);
					}
				}
			} 

			do_action('tourmaster_theme_option_filewrite');
			
		} // tourmaster_gdlr_core_import_additional_options
	}

	// add single booking sidebar option
	add_filter('gdlr_core_pb_wrapper_sidebar_options', 'tourmaster_gdlr_core_pb_wrapper_sidebar_options');
	if( !function_exists('tourmaster_gdlr_core_pb_wrapper_sidebar_options') ){
		function tourmaster_gdlr_core_pb_wrapper_sidebar_options( $options ){
			$options['general']['options'] = array(
				'enable-booking-bar' => array(
					'title' => esc_html__('Enable Single Booking Bar', 'tourmaster'),
					'type' => 'combobox',
					'options' => array(
						'disable' => esc_html__('Disable', 'tourmaster'),
						'left' => esc_html__('Left', 'tourmaster'),
						'right' => esc_html__('Right', 'tourmaster')
					),
					'default' => 'disable',
					'description' => esc_html__('Only apply when item is inside single room/tour page', 'tourmaster')
				),
				'tour-booking-bar-style' => array(
					'title' => esc_html__('Tour Booking Bar Style', 'tourmaster'),
					'type' => 'combobox',
					'options' => array(
						'style-1' => esc_html__('Style 1', 'tourmaster'),
						'style-2' => esc_html__('Style 2', 'tourmaster'),
						'style-3' => esc_html__('Style 3', 'tourmaster'),
					)
				),
			) + $options['general']['options'];

			return $options;
		}
	}

	// clear data for wpml translation
	add_action('wp', 'tourmaster_clear_option_for_translation');
	if( !function_exists('tourmaster_clear_option_for_translation') ){
		function tourmaster_clear_option_for_translation(){
			unset($GLOBALS['tourmaster_general']);
			unset($GLOBALS['tourmaster_room_general']);
			unset($GLOBALS['tourmaster_page_option']);
			unset($GLOBALS['tourmaster_custom_tour_taxs']);
		}	
	}	